/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FlagRenderer;
import net.minecraft.client.render.model.ModelFlag;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindManager;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererFlag
extends TileEntityRenderer<TileEntityFlag> {
    private final ModelFlag flagModel = new ModelFlag();
    private FlagRenderer flagRenderer = null;

    @Override
    public void doRender(Tessellator tessellator, TileEntityFlag tileEntity, double x, double y, double z, float partialTick) {
        World theWorld = Minecraft.getMinecraft((Object)this).theWorld;
        int blockUnder = theWorld.getBlockId(tileEntity.x, tileEntity.y - 1, tileEntity.z);
        boolean shortPole = blockUnder == Block.flag.id;
        WindManager theWind = theWorld.getWorldType().getWindManager();
        float angle = theWind.getWindDirection(theWorld, (float)x, (float)y, (float)z) * 360.0f;
        this.doRender(tileEntity, x, y, z, partialTick, shortPole, angle);
    }

    public void doRender(TileEntityFlag tileEntity, double x, double y, double z, float partialTick, boolean shortPole, float rotationAngle) {
        if (this.flagRenderer == null) {
            this.flagRenderer = new FlagRenderer(this.renderDispatcher.renderEngine);
        }
        this.flagRenderer.updateTexture(tileEntity);
        float sway = (float)(((double)Minecraft.getMinecraft((Object)this).theWorld.getWorldTime() + (double)partialTick) / 1.5 % (Math.PI * 2));
        GL11.glPushMatrix();
        float scale = 1.0f;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.loadTexture("/item/flag.png");
        if (shortPole) {
            this.flagModel.renderPoleShort();
        } else {
            this.flagModel.renderBase();
            this.flagModel.renderPole();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)Math.sin(sway) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.flagModel.renderFlag();
        this.renderDispatcher.renderEngine.bindTexture(this.flagRenderer.getTexture());
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)769, (int)768);
        this.flagModel.renderFlagOverlay();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        float f4 = 0.01666667f;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.07f);
        GL11.glScalef((float)0.01666667f, (float)-0.01666667f, (float)0.01666667f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-0.01666667f);
        GL11.glPopMatrix();
    }
}

