/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelPiston;
import net.minecraft.client.render.block.model.BlockModelPistonHead;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.piston.BlockPistonHead;
import net.minecraft.core.block.piston.TileEntityPistonMoving;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererPiston
extends TileEntityRenderer<TileEntityPistonMoving> {
    private static final BlockModelPistonHead blockModelPistonHead = (BlockModelPistonHead)BlockModelDispatcher.getInstance().getDispatch(Block.pistonHead);
    private RenderBlocks renderBlocks;
    private final Minecraft mc = Minecraft.getMinecraft(this);

    @Override
    public void onWorldChanged(World world) {
        this.renderBlocks = new RenderBlocks(world, world);
    }

    @Override
    public void doRender(Tessellator tessellator, TileEntityPistonMoving tileEntity, double x, double y, double z, float partialTick) {
        Block block = Block.blocksList[tileEntity.getMovedId()];
        if (block != null && tileEntity.getProgress(partialTick) < 1.0f) {
            this.loadTexture("/terrain.png");
            Lighting.disable();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            if (this.mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            tessellator.startDrawingQuads();
            tessellator.setTranslation((float)x - (float)tileEntity.x + tileEntity.getXOff(partialTick), (float)y - (float)tileEntity.y + tileEntity.getYOff(partialTick), (float)z - (float)tileEntity.z + tileEntity.getZOff(partialTick));
            tessellator.setColorOpaque(1, 1, 1);
            if (block == Block.pistonHead && tileEntity.getProgress(partialTick) < 0.5f) {
                BlockModel.setRenderBlocks(this.renderBlocks);
                blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (BlockPistonHead)block, tileEntity.x, tileEntity.y, tileEntity.z, false);
            } else if (tileEntity.isSourcePiston() && !tileEntity.isExtending()) {
                BlockModelPiston pistonBase = (BlockModelPiston)BlockModelDispatcher.getInstance().getDispatch(block);
                ((BlockPistonHead)Block.pistonHead).func_31052_a_(pistonBase.getFaceTexture());
                BlockModel.setRenderBlocks(this.renderBlocks);
                blockModelPistonHead.renderPistonHeadNoCulling(tessellator, (BlockPistonHead)Block.pistonHead, tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.getProgress(partialTick) < 0.5f);
                ((BlockPistonHead)Block.pistonHead).func_31051_a();
                tessellator.setTranslation((float)x - (float)tileEntity.x, (float)y - (float)tileEntity.y, (float)z - (float)tileEntity.z);
                pistonBase.renderNoCulling(tessellator, tileEntity.x, tileEntity.y, tileEntity.z);
            } else {
                BlockModel.setRenderBlocks(this.renderBlocks);
                BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                model.renderNoCulling(tessellator, tileEntity.x, tileEntity.y, tileEntity.z);
            }
            tessellator.setTranslation(0.0, 0.0, 0.0);
            tessellator.draw();
            Lighting.enableLight();
        }
    }
}

