/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCoordinate;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.IChunkProvider;

public class ChunkProviderClient
implements IChunkProvider {
    private Chunk blankChunk;
    private Map chunkMapping = new HashMap();
    private List field_889_c = new ArrayList();
    private World worldObj;

    public ChunkProviderClient(World world) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        if (this != null) {
            return true;
        }
        ChunkCoordinate chunkcoordintpair = new ChunkCoordinate(chunkX, chunkZ);
        return this.chunkMapping.containsKey(chunkcoordintpair);
    }

    @Override
    public void regenerateChunk(int chunkX, int chunkZ) {
    }

    public void func_539_c(int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isChunkEmpty()) {
            chunk.onUnload();
        }
        this.chunkMapping.remove(new ChunkCoordinate(i, j));
        this.field_889_c.remove(chunk);
    }

    @Override
    public Chunk prepareChunk(int chunkX, int chunkZ) {
        ChunkCoordinate chunkcoordintpair = new ChunkCoordinate(chunkX, chunkZ);
        Chunk chunk = new Chunk(this.worldObj, chunkX, chunkZ);
        this.chunkMapping.put(chunkcoordintpair, chunk);
        chunk.isLoaded = true;
        return chunk;
    }

    @Override
    public Chunk provideChunk(int chunkX, int chunkZ) {
        ChunkCoordinate chunkcoordintpair = new ChunkCoordinate(chunkX, chunkZ);
        Chunk chunk = (Chunk)this.chunkMapping.get(chunkcoordintpair);
        if (chunk == null) {
            return this.blankChunk;
        }
        return chunk;
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, ProgressListener progressUpdate) {
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
    }

    @Override
    public String getInfoString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.size();
    }
}

