/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

public enum InventoryAction {
    CLICK_LEFT,
    CLICK_RIGHT,
    DROP_HELD_SINGLE,
    DROP_HELD_STACK,
    HOTBAR_ITEM_SWAP,
    DRAG_ITEMS_ALL,
    DRAG_ITEMS_ONE,
    PICKUP_SIMILAR,
    MOVE_STACK,
    MOVE_SINGLE_ITEM,
    MOVE_ALL,
    MOVE_SIMILAR,
    DROP,
    INTERACT_SLOT,
    INTERACT_GRABBED,
    EQUIP_ARMOR,
    SORT,
    CREATIVE_GRAB,
    CREATIVE_MOVE,
    CREATIVE_DELETE;

    private static final InventoryAction[] actions;
    private int id;

    private static void setId(InventoryAction action, int id) {
        InventoryAction.actions[id] = action;
        action.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static InventoryAction get(int id) {
        if (id < 0 || id >= actions.length) {
            return null;
        }
        return actions[id];
    }

    static {
        actions = new InventoryAction[32];
        InventoryAction.setId(CLICK_LEFT, 0);
        InventoryAction.setId(CLICK_RIGHT, 1);
        InventoryAction.setId(DROP_HELD_SINGLE, 2);
        InventoryAction.setId(DROP_HELD_STACK, 3);
        InventoryAction.setId(HOTBAR_ITEM_SWAP, 4);
        InventoryAction.setId(DRAG_ITEMS_ALL, 5);
        InventoryAction.setId(DRAG_ITEMS_ONE, 6);
        InventoryAction.setId(PICKUP_SIMILAR, 7);
        InventoryAction.setId(MOVE_STACK, 8);
        InventoryAction.setId(MOVE_SINGLE_ITEM, 9);
        InventoryAction.setId(MOVE_ALL, 10);
        InventoryAction.setId(MOVE_SIMILAR, 11);
        InventoryAction.setId(DROP, 12);
        InventoryAction.setId(CREATIVE_GRAB, 13);
        InventoryAction.setId(CREATIVE_MOVE, 14);
        InventoryAction.setId(CREATIVE_DELETE, 15);
        InventoryAction.setId(INTERACT_SLOT, 16);
        InventoryAction.setId(INTERACT_GRABBED, 17);
        InventoryAction.setId(EQUIP_ARMOR, 18);
        InventoryAction.setId(SORT, 19);
    }
}

