/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.Random;
import net.minecraft.core.item.ItemStack;

public class WeightedRandomLootObject {
    private ItemStack itemStack;
    private int yieldMin;
    private int yieldMax;
    private int yieldFixed;
    private boolean isRandomYield;
    private final Random random = new Random();

    public WeightedRandomLootObject(ItemStack itemStack, int yieldMin, int yieldMax) {
        this.itemStack = itemStack;
        this.yieldMin = yieldMin;
        this.yieldMax = yieldMax;
        this.isRandomYield = true;
    }

    public WeightedRandomLootObject(ItemStack itemStack, int yieldFixed) {
        this.itemStack = itemStack;
        this.yieldFixed = yieldFixed;
        this.isRandomYield = false;
    }

    public WeightedRandomLootObject(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.yieldFixed = 1;
        this.isRandomYield = false;
    }

    public ItemStack getDefinedItemStack() {
        return this.itemStack;
    }

    public int getMinYield() {
        return this.yieldMin;
    }

    public int getMaxYield() {
        return this.yieldMax;
    }

    public int getFixedYield() {
        return this.yieldFixed;
    }

    public boolean isRandom() {
        return this.isRandomYield;
    }

    public ItemStack getItemStack() {
        int amount = this.isRandomYield ? this.random.nextInt(this.yieldMax - this.yieldMin + 1) + this.yieldMin : this.yieldFixed;
        ItemStack newItemStack = new ItemStack(this.itemStack.itemID, amount, this.itemStack.getMetadata());
        return newItemStack;
    }
}

