/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonEntry;
import com.b100.json.element.JsonObject;
import com.b100.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.MD5String;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsSyncher;
import net.minecraft.core.player.Session;

public class StatsCounter {
    private final Map<Stat, Integer> statMap1 = new HashMap<Stat, Integer>();
    private final Map<Stat, Integer> statMap2 = new HashMap<Stat, Integer>();
    private boolean modified = false;
    private final StatsSyncher statsSyncher;

    public StatsCounter(Session session, File mcDir) {
        File statsFolder = new File(mcDir, "stats");
        FileUtils.createFolder(statsFolder);
        StatsCounter.relocateStatFiles(mcDir, statsFolder);
        this.statsSyncher = new StatsSyncher(session, this, statsFolder);
    }

    public void addValueToStat(Stat stat, int value) {
        this.addValueToStatMap(this.statMap2, stat, value);
        this.addValueToStatMap(this.statMap1, stat, value);
        this.modified = true;
    }

    private void addValueToStatMap(Map<Stat, Integer> map, Stat stat, int value) {
        Integer integer = map.get(stat);
        int currentValue = integer != null ? integer : 0;
        map.put(stat, currentValue + value);
    }

    public Map<Stat, Integer> cloneMap() {
        return new HashMap<Stat, Integer>(this.statMap2);
    }

    public void func_27179_a(Map<Stat, Integer> map) {
        if (map == null) {
            return;
        }
        this.modified = true;
        for (Stat stat : map.keySet()) {
            this.addValueToStatMap(this.statMap2, stat, map.get(stat));
            this.addValueToStatMap(this.statMap1, stat, map.get(stat));
        }
    }

    public void func_27180_b(Map<Stat, Integer> map) {
        if (map == null) {
            return;
        }
        for (Stat stat : map.keySet()) {
            Integer integer = this.statMap2.get(stat);
            int value = integer != null ? integer : 0;
            this.statMap1.put(stat, map.get(stat) + value);
        }
    }

    public void func_27187_c(Map<Stat, Integer> map) {
        if (map == null) {
            return;
        }
        this.modified = true;
        for (Stat stat : map.keySet()) {
            this.addValueToStatMap(this.statMap2, stat, map.get(stat));
        }
    }

    public static Map<Stat, Integer> func_27177_a(String s) {
        HashMap<Stat, Integer> map = new HashMap<Stat, Integer>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject rootObject = jsonParser.parseString(s);
            JsonArray array = rootObject.getArray("stats-change");
            for (JsonElement element : array) {
                JsonObject object = element.getAsObject();
                JsonEntry entry = object.entryList().get(0);
                int i = Integer.parseInt(entry.name);
                int j = entry.value.getAsNumber().getInteger();
                Stat stat = StatList.getStat(i);
                if (stat == null) {
                    System.out.println(i + " is not a valid stat");
                    continue;
                }
                map.put(stat, j);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getStatFileContentString(String username, String localString, Map<Stat, Integer> map) {
        StringBuilder string1 = new StringBuilder();
        StringBuilder string2 = new StringBuilder();
        boolean flag = true;
        string1.append("{\r\n");
        if (username != null && localString != null) {
            string1.append("  \"user\":{\r\n");
            string1.append("    \"name\":\"").append(username).append("\",\r\n");
            string1.append("    \"sessionid\":\"").append(localString).append("\"\r\n");
            string1.append("  },\r\n");
        }
        string1.append("  \"stats-change\":[");
        Iterator<Stat> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Stat stat;
            Stat statbase = stat = iterator.next();
            if (!flag) {
                string1.append("},");
            } else {
                flag = false;
            }
            string1.append("\r\n    {\"").append(statbase.statId).append("\":").append(map.get(statbase));
            string2.append(statbase.statGuid).append(",");
            string2.append(map.get(statbase)).append(",");
        }
        if (!flag) {
            string1.append("}");
        }
        MD5String md5string = new MD5String(localString);
        string1.append("\r\n  ],\r\n");
        string1.append("  \"checksum\":\"").append(md5string.getString(string2.toString())).append("\"\r\n");
        string1.append("}");
        return string1.toString();
    }

    public boolean isAchievementUnlocked(Achievement achievement) {
        return this.statMap1.containsKey(achievement);
    }

    public boolean isAchievementUnlockable(Achievement achievement) {
        return achievement.parent == null || this.isAchievementUnlocked(achievement.parent);
    }

    public int readStat(Stat statbase) {
        Integer integer = this.statMap1.get(statbase);
        return integer != null ? integer : 0;
    }

    public void func_27175_b() {
    }

    public void syncStats() {
        this.statsSyncher.syncStatsFileWithMap(this.cloneMap());
    }

    public void func_27178_d() {
        if (this.modified && this.statsSyncher.func_27420_b()) {
            this.statsSyncher.func_27424_a(this.cloneMap());
        }
        this.statsSyncher.func_27425_c();
    }

    public static void relocateStatFiles(File minecraftFolder, File statsFolder) {
        File[] files = minecraftFolder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file3;
            File file = files[i];
            if (!file.getName().startsWith("stats_") || !file.getName().endsWith(".dat") || (file3 = new File(statsFolder, file.getName())).exists()) continue;
            System.out.println("Relocating " + file.getName());
            file.renameTo(file3);
        }
    }
}

