/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockCactus
extends Block
implements IBonemealable {
    public BlockCactus(String key, int id) {
        super(key, id, Material.cactus);
        this.setTicking(true);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        this.onNeighborBlockChange(world, x, y, z, 0);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isAirBlock(x, y + 1, z)) {
            int cactusHeight = 1;
            while (world.getBlockId(x, y - cactusHeight, z) == this.id) {
                ++cactusHeight;
            }
            if (cactusHeight < 3) {
                int i1 = world.getBlockMetadata(x, y, z);
                if (i1 == 15) {
                    world.setBlockWithNotify(x, y + 1, z, this.id);
                    world.setBlockMetadataWithNotify(x, y, z, 0);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, i1 + 1);
                }
            }
        }
    }

    public void growCactusOnTop(World world, int x, int y, int z) {
        int l = 1;
        while (world.getBlockId(x, y + l, z) == this.id) {
            ++l;
        }
        if (world.isAirBlock(x, y + l, z)) {
            world.setBlockWithNotify(x, y + l, z, this.id);
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (float)(y + 1) - f, (float)(z + 1) - f);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, y + 1, (float)(z + 1) - f);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!super.canPlaceBlockAt(world, x, y, z)) {
            return false;
        }
        return this.canBlockStay(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        if (world.getBlockMaterial(x - 1, y, z).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(x + 1, y, z).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(x, y, z - 1).isSolid()) {
            return false;
        }
        if (world.getBlockMaterial(x, y, z + 1).isSolid()) {
            return false;
        }
        int l = world.getBlockId(x, y - 1, z);
        return Block.hasTag(l, BlockTags.GROWS_CACTI);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLiving) {
            entity.hurt(null, 1, DamageType.COMBAT);
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            ((BlockCactus)Block.blocksList[this.id]).growCactusOnTop(world, blockX, blockY, blockZ);
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
        }
        return true;
    }
}

