/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryLargeChest;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockChest
extends BlockTileEntity {
    public static final int directionBits = 3;
    public static final int directionOffset = 0;
    public static final int typeBits = 12;
    public static final int typeOffset = 2;

    protected BlockChest(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side placeSide, EntityLiving entity, double sideHeight) {
        Direction direction = entity.getHorizontalPlacementDirection(placeSide).getOpposite();
        Type type = Type.SINGLE;
        if (entity.isSneaking() && placeSide.isHorizontal() && (entity.rotationLockHorizontal == null || entity.rotationLockHorizontal == Direction.NONE)) {
            int placedOnX = x;
            int placedOnZ = z;
            if (placeSide == Side.NORTH) {
                ++placedOnZ;
            }
            if (placeSide == Side.SOUTH) {
                --placedOnZ;
            }
            if (placeSide == Side.EAST) {
                --placedOnX;
            }
            if (placeSide == Side.WEST) {
                ++placedOnX;
            }
            if (BlockChest.isSingleChest(world, placedOnX, y, placedOnZ)) {
                Direction direction2 = BlockChest.getDirectionFromMeta(world.getBlockMetadata(placedOnX, y, placedOnZ));
                if (direction2 == Direction.NORTH) {
                    if (placeSide == Side.EAST) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.EAST) {
                    if (placeSide == Side.SOUTH) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.SOUTH) {
                    if (placeSide == Side.EAST) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.WEST) {
                    if (placeSide == Side.SOUTH) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        this.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
            }
        } else if (!entity.isSneaking()) {
            if (direction == Direction.NORTH) {
                if (BlockChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.LEFT;
                    this.setType(world, x - 1, y, z, Type.RIGHT);
                }
                if (BlockChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.RIGHT;
                    this.setType(world, x + 1, y, z, Type.LEFT);
                }
            }
            if (direction == Direction.EAST) {
                if (BlockChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.LEFT;
                    this.setType(world, x, y, z - 1, Type.RIGHT);
                }
                if (BlockChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.RIGHT;
                    this.setType(world, x, y, z + 1, Type.LEFT);
                }
            }
            if (direction == Direction.SOUTH) {
                if (BlockChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.RIGHT;
                    this.setType(world, x - 1, y, z, Type.LEFT);
                }
                if (BlockChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.LEFT;
                    this.setType(world, x + 1, y, z, Type.RIGHT);
                }
            }
            if (direction == Direction.WEST) {
                if (BlockChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.RIGHT;
                    this.setType(world, x, y, z - 1, Type.LEFT);
                }
                if (BlockChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.LEFT;
                    this.setType(world, x, y, z + 1, Type.RIGHT);
                }
            }
        }
        int meta = world.getBlockMetadata(x, y, z);
        meta = BlockChest.getMetaWithDirection(meta, direction);
        meta = BlockChest.getMetaWithType(meta, type);
        world.setBlockMetadata(x, y, z, meta);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        BlockChest.dropChestContent(world, x, y, z);
        super.onBlockRemoved(world, x, y, z, data);
    }

    public void checkIfOtherHalfExists(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        Type type = BlockChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Direction direction = BlockChest.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            boolean valid = false;
            if (BlockChest.isChest(world, otherChestX, y, otherChestZ) && BlockChest.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = BlockChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT || type == Type.RIGHT && otherType == Type.LEFT) {
                    valid = true;
                }
            }
            if (!valid) {
                this.setType(world, x, y, z, Type.SINGLE);
                world.markBlocksDirty(x, y, z, x, y, z);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        this.checkIfOtherHalfExists(world, x, y, z);
    }

    public static void dropChestContent(World world, int x, int y, int z) {
        TileEntityChest tileEntityChest = (TileEntityChest)world.getBlockTileEntity(x, y, z);
        if (tileEntityChest == null) {
            System.out.println("Can't drop chest items because tile entity is null at x: " + x + " y:" + y + " z: " + z);
            return;
        }
        for (int i = 0; i < tileEntityChest.getSizeInventory(); ++i) {
            ItemStack itemStack = tileEntityChest.getStackInSlot(i);
            if (itemStack == null) continue;
            EntityItem item = world.dropItem(x, y, z, itemStack);
            item.xd *= 0.5;
            item.yd *= 0.5;
            item.zd *= 0.5;
            item.delayBeforeCanPickup = 0;
        }
    }

    public static boolean isChest(World world, int x, int y, int z) {
        return Block.blocksList[world.getBlockId(x, y, z)] instanceof BlockChest;
    }

    public static boolean isSingleChest(World world, int x, int y, int z) {
        return BlockChest.isChest(world, x, y, z) && BlockChest.getTypeFromMeta(world.getBlockMetadata(x, y, z)) == Type.SINGLE;
    }

    public static boolean isSingleChestWithDirection(World world, int x, int y, int z, Direction direction) {
        int meta = world.getBlockMetadata(x, y, z);
        return BlockChest.isChest(world, x, y, z) && BlockChest.getTypeFromMeta(meta) == Type.SINGLE && BlockChest.getDirectionFromMeta(meta) == direction;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityChest();
    }

    public void setDirection(World world, int x, int y, int z, Direction direction) {
        if (BlockChest.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, BlockChest.getMetaWithDirection(world.getBlockMetadata(x, y, z), direction));
        }
    }

    public void setType(World world, int x, int y, int z, Type type) {
        if (BlockChest.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, BlockChest.getMetaWithType(world.getBlockMetadata(x, y, z), type));
        }
    }

    public Direction getDirection(World world, int x, int y, int z) {
        if (BlockChest.isChest(world, x, y, z)) {
            return BlockChest.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        }
        return null;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isClientSide) {
            return true;
        }
        this.checkIfOtherHalfExists(world, x, y, z);
        player.displayGUIChest(BlockChest.getInventory(world, x, y, z));
        return true;
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        IInventory inventory = (IInventory)((Object)world.getBlockTileEntity(x, y, z));
        int meta = world.getBlockMetadata(x, y, z);
        meta = world.getBlockMetadata(x, y, z);
        Type type = BlockChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            IInventory inv2 = null;
            Direction direction = BlockChest.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            if (BlockChest.isChest(world, otherChestX, y, otherChestZ) && BlockChest.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = BlockChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT) {
                    inv2 = (IInventory)((Object)world.getBlockTileEntity(otherChestX, y, otherChestZ));
                }
                if (type == Type.RIGHT && otherType == Type.LEFT) {
                    inv2 = inventory;
                    inventory = (IInventory)((Object)world.getBlockTileEntity(otherChestX, y, otherChestZ));
                }
            }
            if (inv2 != null) {
                inventory = new InventoryLargeChest("Large Chest", inventory, inv2);
            }
        }
        return inventory;
    }

    public static int getMetaWithDirection(int meta, Direction direction) {
        if (direction == null) {
            return meta;
        }
        meta &= 0xFFFFFFFC;
        return meta |= direction.ordinal() << 0 & 3;
    }

    public static int getMetaWithType(int meta, Type type) {
        if (type == null) {
            return meta;
        }
        meta &= 0xFFFFFFF3;
        return meta |= type.ordinal() << 2 & 0xC;
    }

    public static Direction getDirectionFromMeta(int meta) {
        if ((meta &= 3) == 0) {
            return Direction.NORTH;
        }
        if (meta == 1) {
            return Direction.EAST;
        }
        if (meta == 2) {
            return Direction.SOUTH;
        }
        if (meta == 3) {
            return Direction.WEST;
        }
        return Direction.NONE;
    }

    public static Type getTypeFromMeta(int meta) {
        return Type.get(meta >> 2 & 3);
    }

    public static enum Type {
        SINGLE,
        LEFT,
        RIGHT;


        public static Type get(int i) {
            if (i < 0 || i >= Type.values().length) {
                i = 0;
            }
            return Type.values()[i];
        }
    }
}

