/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockFarmland
extends Block {
    public BlockFarmland(String key, int id) {
        super(key, id, Material.dirt);
        this.setTicking(true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        this.withLightBlock(255);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AABB.getBoundingBoxFromPool(x + 0, y + 0, z + 0, x + 1, y + 1, z + 1);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        if (meta > 0) {
            return new ItemStack[]{new ItemStack(Block.mud)};
        }
        return new ItemStack[]{new ItemStack(Block.dirt)};
    }

    private boolean isCropsNearby(World world, int i, int j, int k) {
        boolean l = false;
        for (int i1 = i - 0; i1 <= i + 0; ++i1) {
            for (int j1 = k - 0; j1 <= k + 0; ++j1) {
                if (world.getBlockId(i1, j + 1, j1) != Block.cropsWheat.id) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    private boolean isWaterNearby(World world, int i, int j, int k) {
        for (int l = i - 4; l <= i + 4; ++l) {
            for (int i1 = j; i1 <= j + 1; ++i1) {
                for (int j1 = k - 4; j1 <= k + 4; ++j1) {
                    if (!Block.hasTag(world.getBlockId(l, i1, j1), BlockTags.IS_WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (world.rand.nextInt(4) == 0 && entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).inventory.armorInventory[0] != null && ((EntityPlayer)entity).inventory.armorInventory[0].getItem() == Item.armorBootsLeather) {
                return;
            }
            if (world.getBlockMetadata(x, y, z) > 0) {
                world.setBlockWithNotify(x, y, z, Block.mud.id);
            } else {
                world.setBlockWithNotify(x, y, z, Block.dirt.id);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        Material material = world.getBlockMaterial(x, y + 1, z);
        if (material.isSolid()) {
            if (world.getBlockMetadata(x, y, z) > 0) {
                world.setBlockWithNotify(x, y, z, Block.mud.id);
            } else {
                world.setBlockWithNotify(x, y, z, Block.dirt.id);
            }
        }
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(5) == 0) {
            if (this.isWaterNearby(world, x, y, z) || world.canBlockBeRainedOn(x, y + 1, z)) {
                world.setBlockMetadataWithNotify(x, y, z, 7);
            } else {
                int l = world.getBlockMetadata(x, y, z);
                if (l > 0) {
                    world.setBlockMetadataWithNotify(x, y, z, l - 1);
                } else if (!this.isCropsNearby(world, x, y, z)) {
                    world.setBlockWithNotify(x, y, z, Block.dirt.id);
                }
            }
        }
    }
}

