/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockFlag
extends BlockTileEntity {
    public BlockFlag(String key, int id, Material material) {
        super(key, id, material);
        float f = 0.125f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        ItemStack stack = new ItemStack(Item.flag);
        if (tileEntity != null) {
            CompoundTag compound = new CompoundTag();
            ((TileEntityFlag)tileEntity).writeFlagNBT(compound);
            stack.getData().putCompound("FlagData", compound);
        }
        return new ItemStack[]{stack};
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isClientSide) {
            int heldItemId;
            TileEntityFlag flag = (TileEntityFlag)world.getBlockTileEntity(x, y, z);
            if (flag.owner != null && !flag.owner.isEmpty() && !player.username.equals(flag.owner)) {
                return false;
            }
            int n = heldItemId = player.getHeldItem() != null ? player.getHeldItem().itemID : 0;
            if (heldItemId == Item.map.id || heldItemId == Item.flag.id) {
                return false;
            }
            player.displayGUIEditFlag(flag);
            return true;
        }
        return true;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        try {
            return new TileEntityFlag();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

