/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public abstract class BlockFluid
extends Block {
    public BlockFluid(String key, int id, Material material) {
        super(key, id, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.setTicking(true);
    }

    public static float getWaterVolume(int data) {
        if ((data &= 0xF) >= 8) {
            data = 0;
        }
        return (float)(data + 1) / 8.0f;
    }

    protected int getDepth(World world, int x, int y, int z) {
        if (world.getBlockMaterial(x, y, z) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(x, y, z) & 0xF;
    }

    protected int getRenderedDepth(WorldSource blockAccess, int x, int y, int z) {
        if (blockAccess.getBlockMaterial(x, y, z) != this.blockMaterial) {
            return -1;
        }
        int meta = blockAccess.getBlockMetadata(x, y, z) & 0xF;
        if (meta >= 8) {
            meta = 0;
        }
        return meta;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return shouldCollideWithFluids && (meta & 0xF) == 0;
    }

    @Override
    public boolean getIsBlockSolid(WorldSource blockAccess, int x, int y, int z, Side side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        return super.getIsBlockSolid(blockAccess, x, y, z, side);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    private Vec3d getFlow(WorldSource world, int x, int y, int z) {
        Vec3d result = Vec3d.createVector(0.0, 0.0, 0.0);
        int depthLocal = this.getRenderedDepth(world, x, y, z);
        for (int i = 0; i < 4; ++i) {
            int mult;
            int depthCheck;
            int checkX = x;
            int checkY = y;
            int checkZ = z;
            if (i == 0) {
                --checkX;
            }
            if (i == 1) {
                --checkZ;
            }
            if (i == 2) {
                ++checkX;
            }
            if (i == 3) {
                ++checkZ;
            }
            if ((depthCheck = this.getRenderedDepth(world, checkX, checkY, checkZ)) < 0) {
                if (world.getBlockMaterial(checkX, checkY, checkZ).blocksMotion() || (depthCheck = this.getRenderedDepth(world, checkX, checkY - 1, checkZ)) < 0) continue;
                mult = depthCheck - (depthLocal - 8);
                result = result.addVector((checkX - x) * mult, (checkY - y) * mult, (checkZ - z) * mult);
                continue;
            }
            mult = depthCheck - depthLocal;
            result = result.addVector((checkX - x) * mult, (checkY - y) * mult, (checkZ - z) * mult);
        }
        result = result.normalize();
        return result;
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3d entityVelocity) {
        if (entity.noPhysics) {
            return;
        }
        Vec3d flowVector = this.getFlow(world, x, y, z);
        entityVelocity.xCoord += flowVector.xCoord;
        entityVelocity.yCoord += flowVector.yCoord;
        entityVelocity.zCoord += flowVector.zCoord;
    }

    @Override
    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    @Override
    public float getBlockBrightness(WorldSource world, int x, int y, int z) {
        float f = world.getLightBrightness(x, y, z);
        float f1 = world.getLightBrightness(x, y + 1, z);
        return Math.max(f, f1);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
    }

    @Override
    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int data;
        if (this.blockMaterial == Material.water && rand.nextInt(64) == 0 && (data = world.getBlockMetadata(x, y, z) & 0xF) > 0 && data < 8) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "liquid.water", rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && world.getBlockMaterial(x, y + 1, z) == Material.air && !world.isBlockOpaqueCube(x, y + 1, z) && rand.nextInt(100) == 0) {
            double xOff = (float)x + rand.nextFloat();
            double yOff = (double)y + this.maxY;
            double zOff = (float)z + rand.nextFloat();
            world.spawnParticle("lava", xOff, yOff, zOff, 0.0, 0.0, 0.0);
        }
    }

    public static double getSlopeAngle(WorldSource blockAccess, int x, int y, int z, Material material) {
        Vec3d vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluid)Block.fluidWaterFlowing).getFlow(blockAccess, x, y, z);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluid)Block.fluidLavaFlowing).getFlow(blockAccess, x, y, z);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        this.checkForHarden(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkForHarden(world, x, y, z);
    }

    private void checkForHarden(World world, int x, int y, int z) {
        int data;
        if (world.getBlockId(x, y, z) != this.id) {
            return;
        }
        if (this.blockMaterial == Material.lava && (world.getBlockMaterial(x, y, z - 1) == Material.water || world.getBlockMaterial(x, y, z + 1) == Material.water || world.getBlockMaterial(x - 1, y, z) == Material.water || world.getBlockMaterial(x + 1, y, z) == Material.water || world.getBlockMaterial(x, y + 1, z) == Material.water)) {
            data = world.getBlockMetadata(x, y, z) & 0xF;
            if (data == 0) {
                world.setBlockWithNotify(x, y, z, Block.obsidian.id);
            } else if (data <= 2) {
                world.setBlockWithNotify(x, y, z, Block.cobbleGranite.id);
            } else if (data <= 4) {
                world.setBlockWithNotify(x, y, z, Block.cobbleStone.id);
            } else {
                world.setBlockWithNotify(x, y, z, Block.cobbleBasalt.id);
            }
            this.fizz(world, x, y, z);
        }
        if (this.blockMaterial == Material.water && (world.getBlockMaterial(x, y, z - 1) == Material.lava || world.getBlockMaterial(x, y, z + 1) == Material.lava || world.getBlockMaterial(x - 1, y, z) == Material.lava || world.getBlockMaterial(x + 1, y, z) == Material.lava || world.getBlockMaterial(x, y + 1, z) == Material.lava) && (data = world.getBlockMetadata(x, y, z) & 0xF) == 0) {
            world.setBlockWithNotify(x, y, z, Block.cobbleLimestone.id);
            this.fizz(world, x, y, z);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return null;
    }

    protected void fizz(World world, int x, int y, int z) {
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

