/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockJar
extends BlockTileEntity {
    public Item item;

    public BlockJar(String key, int id) {
        super(key, id, Material.glass);
        this.setBlockBounds(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return false;
        }
        return super.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        float offset = 0.0f;
        return AABB.getBoundingBoxFromPool((float)x + 0.3125f, (float)y + offset, (float)z + 0.3125f, (float)(x + 1) - 0.3125f, (float)y + 0.375f + offset, (float)(z + 1) - 0.3125f);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        AABB aabb = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        this.minX = aabb.minX - (double)x;
        this.minY = aabb.minY - (double)y;
        this.minZ = aabb.minZ - (double)z;
        this.maxX = aabb.maxX - (double)x;
        this.maxY = aabb.maxY - (double)y;
        this.maxZ = aabb.maxZ - (double)z;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (player.getHeldItem() == null) {
            if (world.getBlockMetadata(x, y, z) == 0) {
                world.setBlockWithNotify(x, y, z, 0);
                world.playSoundAtEntity(null, player, "random.pop", 0.2f, 0.5f);
                if (!world.isClientSide) {
                    world.dropItem(x, y, z, new ItemStack(this.item, 1, 0));
                }
            } else {
                TileEntityFlowerJar tileEntity = (TileEntityFlowerJar)world.getBlockTileEntity(x, y, z);
                int flowerInPot = tileEntity.flowerInPot;
                if (flowerInPot > 0 && BlockJar.hasTag(flowerInPot, BlockTags.PLANTABLE_IN_JAR)) {
                    tileEntity.flowerInPot = 0;
                    world.setBlockMetadataWithNotify(x, y, z, 0);
                    world.playSoundAtEntity(null, player, "random.pop", 0.2f, 0.5f);
                    if (!world.isClientSide) {
                        world.dropItem(x, y, z, new ItemStack(flowerInPot, 1, 0));
                    }
                }
            }
        } else if (world.getBlockMetadata(x, y, z) == 0 && player.getHeldItem().getItem() instanceof ItemBlock) {
            Block blockInHand = ((ItemBlock)player.getHeldItem().getItem()).getBlock();
            if (BlockJar.hasTag(blockInHand.id, BlockTags.PLANTABLE_IN_JAR)) {
                player.getHeldItem().consumeItem(player);
                TileEntityFlowerJar tileEntity = (TileEntityFlowerJar)world.getBlockTileEntity(x, y, z);
                world.setBlockMetadataWithNotify(x, y, z, 1);
                tileEntity.flowerInPot = blockInHand.id;
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: 
            case WORLD: {
                return new ItemStack[]{new ItemStack(this.item)};
            }
        }
        return null;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntityFlowerJar tileEntity = (TileEntityFlowerJar)world.getBlockTileEntity(x, y, z);
        int flowerInPot = tileEntity.flowerInPot;
        if (flowerInPot > 0 && BlockJar.hasTag(flowerInPot, BlockTags.PLANTABLE_IN_JAR)) {
            tileEntity.flowerInPot = 0;
            if (!world.isClientSide) {
                world.dropItem(x, y, z, new ItemStack(flowerInPot, 1, 0));
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityFlowerJar();
    }

    public void setItem(Item item) {
        this.item = item;
    }
}

