/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLayerBase;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockLayerSnow
extends BlockLayerBase {
    public BlockLayerSnow(String key, int id, Material material) {
        super(key, id, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        this.setTicking(true);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        return AABB.getBoundingBoxFromPool((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (float)y + f - 0.125f, (double)z + this.maxZ);
    }

    public void accumulate(World world, int x, int y, int z) {
        boolean negZValid;
        boolean negXValid;
        boolean posZValid;
        boolean posXValid;
        int myMetadata = world.getBlockMetadata(x, y, z);
        if (myMetadata == 7) {
            return;
        }
        boolean bl = posXValid = world.isBlockOpaqueCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == this.id && world.getBlockMetadata(x + 1, y, z) >= myMetadata;
        if (!posXValid) {
            return;
        }
        boolean bl2 = posZValid = world.isBlockOpaqueCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == this.id && world.getBlockMetadata(x, y, z + 1) >= myMetadata;
        if (!posZValid) {
            return;
        }
        boolean bl3 = negXValid = world.isBlockOpaqueCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == this.id && world.getBlockMetadata(x - 1, y, z) >= myMetadata;
        if (!negXValid) {
            return;
        }
        boolean bl4 = negZValid = world.isBlockOpaqueCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == this.id && world.getBlockMetadata(x, y, z - 1) >= myMetadata;
        if (!negZValid) {
            return;
        }
        world.setBlockMetadata(x, y, z, myMetadata + 1);
        world.markBlockNeedsUpdate(x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y - 1, z);
        if (l == 0 || !Block.blocksList[l].isSolidRender() && !(Block.blocksList[l] instanceof BlockLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(x, y - 1, z);
        return material == Material.leaves || material.blocksMotion();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.func_314_h(world, x, y, z);
    }

    private boolean func_314_h(World world, int i, int j, int k) {
        if (!this.canPlaceBlockAt(world, i, j, k)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, i, j, k, world.getBlockMetadata(i, j, k), null);
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this, meta + 1)};
            }
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
            case EXPLOSION: 
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(Item.ammoSnowball, meta + 1)};
            }
        }
        return null;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.getSavedLightValue(LightLayer.Block, x, y, z) > 11) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
        if (world.getBlockBiome(x, y, z) != null && !world.getBlockBiome(x, y, z).hasSurfaceSnow() && world.seasonManager.getCurrentSeason() != null && world.seasonManager.getCurrentSeason().letWeatherCleanUpSnow) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }
}

