/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public class BlockLeavesCacao
extends BlockLeavesBase
implements IBonemealable {
    public BlockLeavesCacao(String key, int id) {
        super(key, id, Material.leaves);
        this.setTicking(true);
    }

    public boolean canBeansGrow(World world, int x, int y, int z) {
        for (int x1 = x - 1; x1 < x + 1; ++x1) {
            for (int z1 = z - 1; z1 < z + 1; ++z1) {
                if (world.getBlock(x1, y, z1) != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        int growthRate = (meta & 0xF0) >> 4;
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        if (growthRate > 1) {
            return new ItemStack[]{new ItemStack(Item.dye, growthRate - 1, 3)};
        }
        return super.getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.blockActivated(world, x, y, z, player);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        int decayData = meta & 0xF;
        int growthRate = (meta & 0xF0) >> 4;
        if (growthRate > 0) {
            world.playSoundAtEntity(null, player, "random.pop", 0.2f, 0.5f);
            if (!world.isClientSide) {
                this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null);
            }
            world.setBlockMetadataWithNotify(x, y, z, decayData);
            world.scheduleBlockUpdate(x, y, z, BlockLeavesCacao.leavesCacao.id, this.tickRate());
            return true;
        }
        return super.blockActivated(world, x, y, z, player);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        int meta = world.getBlockMetadata(x, y, z);
        int growthRate = (meta & 0xF0) >> 4;
        if (rand.nextInt(10) == 0) {
            if (world.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_SUMMER) {
                if (this.canBeansGrow(world, x, y, z) && growthRate < 4) {
                    world.setBlockMetadataWithNotify(x, y, z, ++growthRate << 4 | meta);
                    world.scheduleBlockUpdate(x, y, z, BlockLeavesCacao.leavesCacao.id, this.tickRate());
                }
            } else if (growthRate > 0) {
                world.setBlockMetadataWithNotify(x, y, z, meta & 0xF);
                world.scheduleBlockUpdate(x, y, z, BlockLeavesCacao.leavesCacao.id, this.tickRate());
            }
        }
    }

    @Override
    protected Block getSapling() {
        return Block.saplingCacao;
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if ((meta & 0xF0) >> 4 < 4) {
            if (!world.isClientSide) {
                if (world.seasonManager.getCurrentSeason() != Seasons.OVERWORLD_SUMMER) {
                    return true;
                }
                world.setBlockMetadataWithNotify(blockX, blockY, blockZ, 0x40 | meta);
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
            }
            return true;
        }
        return false;
    }
}

