/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockMoss
extends Block
implements IBonemealable {
    public static final Map<Block, Block> stoneToMossMap = new HashMap<Block, Block>();
    public static final Map<Block, Block> mossToStoneMap = new HashMap<Block, Block>();

    public BlockMoss(String key, int id) {
        super(key, id, Material.moss);
        this.setTicking(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.areBlocksLoaded(x, y, z, 16) && this.canMossSpread(world, x, y, z) && rand.nextInt(20) == 0) {
            this.spreadMossRandomly(world, x, y, z, rand, false);
        }
    }

    public boolean spreadMossRandomly(World world, int x, int y, int z, Random random, boolean ignoreLight) {
        Block mossStone;
        int mossX = x;
        int mossY = y;
        int mossZ = z;
        int side = random.nextInt(6);
        if (side == 0) {
            --mossZ;
        }
        if (side == 1) {
            ++mossX;
        }
        if (side == 2) {
            ++mossZ;
        }
        if (side == 3) {
            --mossX;
        }
        if (side == 4) {
            ++mossY;
        }
        if (side == 5) {
            --mossY;
        }
        if ((ignoreLight || !Block.isBuried(world, mossX, mossY, mossZ)) && (mossStone = BlockMoss.getMossBlock(world.getBlockId(mossX, mossY, mossZ))) != null) {
            world.setBlockWithNotify(mossX, mossY, mossZ, mossStone.id);
            return true;
        }
        return false;
    }

    public boolean canMossSpread(World world, int x, int y, int z) {
        return world.getBlockLightValue(x, y + 1, z) <= 5 && world.getBlockLightValue(x, y - 1, z) <= 5 && world.getBlockLightValue(x + 1, y, z) <= 5 && world.getBlockLightValue(x - 1, y, z) <= 5 && world.getBlockLightValue(x, y, z - 1) <= 5 && world.getBlockLightValue(x, y, z + 1) <= 5;
    }

    public static Block getMossBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockMoss.getMossBlock(Block.blocksList[blockId]);
    }

    public static Block getMossBlock(Block stoneBlock) {
        return stoneToMossMap.get(stoneBlock);
    }

    public static Block getStoneBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return BlockMoss.getStoneBlock(Block.blocksList[blockId]);
    }

    public static Block getStoneBlock(Block mossBlock) {
        return mossToStoneMap.get(mossBlock);
    }

    public static void initMossMap() {
        stoneToMossMap.put(stone, mossStone);
        stoneToMossMap.put(granite, mossGranite);
        stoneToMossMap.put(limestone, mossLimestone);
        stoneToMossMap.put(basalt, mossBasalt);
        stoneToMossMap.put(cobbleStone, cobbleStoneMossy);
        stoneToMossMap.put(brickStonePolished, brickStonePolishedMossy);
        stoneToMossMap.put(logOak, logOakMossy);
        for (Map.Entry<Block, Block> entry : stoneToMossMap.entrySet()) {
            mossToStoneMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
            for (int j1 = 0; j1 < 32; ++j1) {
                int k1 = blockX;
                int l1 = blockY;
                int i2 = blockZ;
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    k1 += world.rand.nextInt(3) - 1;
                    l1 += (world.rand.nextInt(3) - 1) * world.rand.nextInt(3) / 2;
                    i2 += world.rand.nextInt(3) - 1;
                }
                if (Block.isBuried(world, k1, l1, i2) || world.getBlockLightValue(k1, l1 + 1, i2) > 5 || world.getBlockLightValue(k1, l1 - 1, i2) > 5 || world.getBlockLightValue(k1 + 1, l1, i2) > 5 || world.getBlockLightValue(k1 - 1, l1, i2) > 5 || world.getBlockLightValue(k1, l1, i2 - 1) > 5 || world.getBlockLightValue(k1, l1, i2 + 1) > 5) continue;
                if (world.getBlockId(k1, l1, i2) == Block.stone.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.mossStone.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Block.limestone.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.mossLimestone.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Block.granite.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.mossGranite.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Block.basalt.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.mossBasalt.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Block.cobbleStone.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.cobbleStoneMossy.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Block.brickStonePolished.id) {
                    world.setBlockWithNotify(k1, l1, i2, Block.brickStonePolishedMossy.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) != Block.logOak.id) continue;
                world.setBlockWithNotify(k1, l1, i2, Block.logOakMossy.id);
            }
        }
        return true;
    }
}

