/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockPressurePlate
extends Block {
    private final MobType triggerMobType;

    public BlockPressurePlate(String key, int id, MobType mobType, Material material) {
        super(key, id, material);
        this.triggerMobType = mobType;
        this.setTicking(true);
        float pixel = 0.0625f;
        this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, pixel / 2.0f, 1.0f - pixel);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockMetadata(x, y, z) != 0) {
            this.updateState(world, x, y, z);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockMetadata(x, y, z) != 1) {
            this.updateState(world, x, y, z);
        }
    }

    private void updateState(World world, int x, int y, int z) {
        boolean isPressed = world.getBlockMetadata(x, y, z) == 1;
        boolean isSteppedOn = false;
        float f = 0.125f;
        List<Entity> list = null;
        if (this.triggerMobType == MobType.EVERYTHING) {
            list = world.getEntitiesWithinAABBExcludingEntity(null, AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (double)y + 0.25, (float)(z + 1) - f));
        }
        if (this.triggerMobType == MobType.MOBS) {
            list = world.getEntitiesWithinAABB(EntityLiving.class, AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (double)y + 0.25, (float)(z + 1) - f));
        }
        if (this.triggerMobType == MobType.PLAYERS) {
            list = world.getEntitiesWithinAABB(EntityPlayer.class, AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (double)y + 0.25, (float)(z + 1) - f));
        }
        if (list != null && list.size() > 0) {
            isSteppedOn = true;
        }
        if (isSteppedOn && !isPressed) {
            world.setBlockMetadataWithNotify(x, y, z, 1);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!isSteppedOn && isPressed) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (isSteppedOn) {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
        }
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (data > 0) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        boolean isPressed = world.getBlockMetadata(x, y, z) == 1;
        float pixel = 0.0625f;
        if (isPressed) {
            this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, 0.03125, 1.0f - pixel);
        } else {
            this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, 0.0625, 1.0f - pixel);
        }
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return blockAccess.getBlockMetadata(x, y, z) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        return side == 1;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public int getPistonPushReaction() {
        return 1;
    }

    public static enum MobType {
        EVERYTHING,
        MOBS,
        PLAYERS;

    }
}

