/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockRedstone
extends Block {
    public BlockRedstone(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        return this.isPoweringTo(world, x, y, z, side);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        this.spawnParticles(world, x, y, z);
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        double d = 0.0625;
        for (int i = 0; i < 3; ++i) {
            double px = (float)x + random.nextFloat();
            double py = (float)y + random.nextFloat();
            double pz = (float)z + random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)(y + 0) - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)(z + 0) - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)(x + 0) - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, red, green, blue);
        }
    }
}

