/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockRedstoneRepeater
extends Block {
    public static final double[] field_22024_a = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] field_22023_b = new int[]{1, 2, 3, 4};
    public final boolean isRepeaterPowered;

    public BlockRedstoneRepeater(String key, int id, boolean flag) {
        super(key, id, Material.decoration);
        this.isRepeaterPowered = flag;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return false;
        }
        return super.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Item.repeater)};
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        if (!world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            return false;
        }
        return super.canBlockStay(world, x, y, z);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        int l = world.getBlockMetadata(x, y, z);
        boolean flag = this.func_22022_g(world, x, y, z, l);
        if (this.isRepeaterPowered && !flag) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.repeaterIdle.id, l);
        } else if (!this.isRepeaterPowered) {
            world.setBlockAndMetadataWithNotify(x, y, z, Block.repeaterActive.id, l);
            if (!flag) {
                int i1 = (l & 0xC) >> 2;
                world.scheduleBlockUpdate(x, y, z, Block.repeaterActive.id, field_22023_b[i1] * 2);
            }
        }
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        return this.isPoweringTo(world, x, y, z, side);
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int i1 = blockAccess.getBlockMetadata(x, y, z) & 3;
        if (i1 == 0 && side == 3) {
            return true;
        }
        if (i1 == 1 && side == 4) {
            return true;
        }
        if (i1 == 2 && side == 2) {
            return true;
        }
        return i1 == 3 && side == 5;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        int i1 = world.getBlockMetadata(x, y, z);
        boolean flag = this.func_22022_g(world, x, y, z, i1);
        int j1 = (i1 & 0xC) >> 2;
        if (this.isRepeaterPowered && !flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, field_22023_b[j1] * 2);
        } else if (!this.isRepeaterPowered && flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, field_22023_b[j1] * 2);
        }
    }

    private boolean func_22022_g(World world, int i, int j, int k, int l) {
        int i1 = l & 3;
        switch (i1) {
            case 0: {
                return world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3) || world.getBlockId(i, j, k + 1) == Block.wireRedstone.id && world.getBlockMetadata(i, j, k + 1) > 0;
            }
            case 2: {
                return world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2) || world.getBlockId(i, j, k - 1) == Block.wireRedstone.id && world.getBlockMetadata(i, j, k - 1) > 0;
            }
            case 3: {
                return world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5) || world.getBlockId(i + 1, j, k) == Block.wireRedstone.id && world.getBlockMetadata(i + 1, j, k) > 0;
            }
            case 1: {
                return world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4) || world.getBlockId(i - 1, j, k) == Block.wireRedstone.id && world.getBlockMetadata(i - 1, j, k) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        int l = world.getBlockMetadata(x, y, z);
        int i1 = (l & 0xC) >> 2;
        i1 = i1 + 1 << 2 & 0xC;
        world.setBlockMetadataWithNotify(x, y, z, i1 | l & 3);
        return true;
    }

    @Override
    public boolean canProvidePower() {
        return false;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        int l = entity.getHorizontalPlacementDirection((Side)side).index;
        world.setBlockMetadataWithNotify(x, y, z, l);
        boolean flag = this.func_22022_g(world, x, y, z, l);
        if (flag) {
            world.scheduleBlockUpdate(x, y, z, this.id, 1);
        }
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (!this.isRepeaterPowered) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        double px = (double)((float)x + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double py = (double)((float)y + 0.4f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double pz = (double)((float)z + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
        double xOffset = 0.0;
        double zOffset = 0.0;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        if (rand.nextInt(2) == 0) {
            switch (meta & 3) {
                case 0: {
                    zOffset = -0.3125;
                    break;
                }
                case 2: {
                    zOffset = 0.3125;
                    break;
                }
                case 3: {
                    xOffset = -0.3125;
                    break;
                }
                case 1: {
                    xOffset = 0.3125;
                }
            }
        } else {
            int i1 = (meta & 0xC) >> 2;
            switch (meta & 3) {
                case 0: {
                    zOffset = field_22024_a[i1];
                    break;
                }
                case 2: {
                    zOffset = -field_22024_a[i1];
                    break;
                }
                case 3: {
                    xOffset = field_22024_a[i1];
                    break;
                }
                case 1: {
                    xOffset = -field_22024_a[i1];
                }
            }
        }
        world.spawnParticle("reddust", px + xOffset, py, pz + zOffset, red, green, blue);
    }
}

