/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class BlockSugarcane
extends Block
implements IBonemealable {
    public BlockSugarcane(String key, int id) {
        super(key, id, Material.plant);
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 1.0, 0.5f + f);
        this.setTicking(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isAirBlock(x, y + 1, z)) {
            int l = 1;
            while (world.getBlockId(x, y - l, z) == this.id) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockMetadata(x, y, z);
                if (i1 == 15) {
                    world.setBlockWithNotify(x, y + 1, z, this.id);
                    world.setBlockMetadataWithNotify(x, y, z, 0);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, i1 + 1);
                }
            }
        }
    }

    public void growReedOnTop(World world, int x, int y, int z) {
        int l = 1;
        while (world.getBlockId(x, y + l, z) == this.id) {
            ++l;
        }
        if (world.isAirBlock(x, y + l, z)) {
            world.setBlockWithNotify(x, y + l, z, this.id);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y - 1, z);
        if (l == this.id) {
            return true;
        }
        if (Block.blocksList[l] == null) {
            return false;
        }
        if (!Block.blocksList[l].hasTag(BlockTags.GROWS_SUGAR_CANE)) {
            return false;
        }
        if (Block.hasTag(world.getBlockId(x - 1, y - 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x + 1, y - 1, z), BlockTags.IS_WATER)) {
            return true;
        }
        if (Block.hasTag(world.getBlockId(x, y - 1, z - 1), BlockTags.IS_WATER)) {
            return true;
        }
        return Block.hasTag(world.getBlockId(x, y - 1, z + 1), BlockTags.IS_WATER);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.checkBlockCoordValid(world, x, y, z);
    }

    protected final void checkBlockCoordValid(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, i, j, k, world.getBlockMetadata(i, j, k), null);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Item.sugarcane)};
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return this.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            ((BlockSugarcane)Block.blocksList[this.id]).growReedOnTop(world, blockX, blockY, blockZ);
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
        }
        return true;
    }
}

