/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.enums.EnumCreatureType;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet132SetMobSpawner;
import net.minecraft.core.util.phys.AABB;

public class TileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    private String mobId = "Pig";
    public double yaw;
    public double yaw2 = 0.0;
    private int nearby;

    public String getMobId() {
        return this.mobId;
    }

    public void setMobId(String mobId) {
        this.mobId = mobId != null && mobId.equalsIgnoreCase("none") ? null : mobId;
    }

    public boolean anyPlayerInRange() {
        return this.worldObj != null && this.worldObj.getClosestPlayer((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, 16.0) != null;
    }

    @Override
    public void tick() {
        if (this.worldObj.getBlockId(this.x, this.y, this.z) != Block.mobspawner.id) {
            return;
        }
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        double d = (float)this.x + this.worldObj.rand.nextFloat();
        double d2 = (float)this.y + this.worldObj.rand.nextFloat();
        double d4 = (float)this.z + this.worldObj.rand.nextFloat();
        this.worldObj.spawnParticle("smoke", d, d2, d4, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("flame", d, d2, d4, 0.0, 0.0, 0.0);
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        if (!this.worldObj.isClientSide) {
            if (this.worldObj.difficultySetting == 0) {
                return;
            }
            if (this.mobId == null || this.mobId.equalsIgnoreCase("none")) {
                return;
            }
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            if (this.mobId == null) {
                this.nearby = this.countNearbySpawners();
            }
            int byte0 = 4;
            for (int i = 0; i < byte0; ++i) {
                EntityLiving entityliving = null;
                if (this.mobId.equalsIgnoreCase("random")) {
                    List<SpawnListEntry> list = this.worldObj.getBlockBiome(this.x, this.y, this.z).getSpawnableList(EnumCreatureType.monster);
                    SpawnListEntry entry = list.get(this.worldObj.rand.nextInt(list.size()));
                    entityliving = (EntityLiving)EntityDispatcher.createEntityInWorld(EntityDispatcher.classToKeyMap.get(entry.entityClass), this.worldObj);
                } else {
                    entityliving = (EntityLiving)EntityDispatcher.createEntityInWorld(this.mobId, this.worldObj);
                }
                if (entityliving == null) {
                    return;
                }
                int j = this.worldObj.getEntitiesWithinAABB(entityliving.getClass(), AABB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1, this.y + 1, this.z + 1).expand(8.0, 4.0, 8.0)).size();
                if (j >= 6) {
                    this.updateDelay();
                    return;
                }
                double d6 = (double)this.x + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                double d7 = this.y + this.worldObj.rand.nextInt(3) - 1;
                double d8 = (double)this.z + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                entityliving.moveTo(d6, d7, d8, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.getCanSpawnHere()) {
                    this.updateDelay();
                    continue;
                }
                this.worldObj.entityJoinedWorld(entityliving);
                for (int k = 0; k < 20; ++k) {
                    double d1 = (double)this.x + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d3 = (double)this.y + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d5 = (double)this.z + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    this.worldObj.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0);
                    this.worldObj.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0);
                    this.worldObj.playSoundAtEntity(null, entityliving, "mob.ghast.fireball", 0.025f, 0.75f);
                }
                entityliving.spawnExplosionParticle();
                this.updateDelay();
            }
        }
        super.tick();
    }

    @Override
    public Packet getDescriptionPacket() {
        return new Packet132SetMobSpawner(this.x, this.y, this.z, this.mobId);
    }

    public int countNearbySpawners() {
        int r = 4;
        int count = 0;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int id = this.worldObj.getBlockId(this.x + i, this.y + j, this.z + k);
                    if (id != Block.mobspawner.id) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private void updateDelay() {
        this.delay = 200 + this.worldObj.rand.nextInt(600);
        if (this.mobId == null) {
            this.delay *= 2;
            System.out.println("x2");
            if (this.nearby > 1) {
                System.out.println("x4");
                this.delay *= 4;
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.setMobId(tag.getString("EntityId"));
        this.delay = tag.getShort("Delay");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putString("EntityId", this.mobId != null ? this.mobId : "none");
        tag.putShort("Delay", (short)this.delay);
    }
}

