/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockMotionSensor;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class TileEntitySensor
extends TileEntity {
    public TileEntitySensor() {
        Random rand = new Random();
    }

    public String getInvName() {
        return "Sensor";
    }

    private boolean canSeeInFront(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 2 && !world.isBlockOpaqueCube(x, y, z - 1)) {
            return true;
        }
        if (metadata == 3 && !world.isBlockOpaqueCube(x, y, z + 1)) {
            return true;
        }
        if (metadata == 4 && !world.isBlockOpaqueCube(x - 1, y, z)) {
            return true;
        }
        return metadata == 5 && !world.isBlockOpaqueCube(x + 1, y, z);
    }

    private AABB getDetectionRadius(int x, int y, int z, int metadata) {
        if (metadata == 2) {
            return AABB.getBoundingBoxFromPool(x, y, z - 2, x + 1, (float)y + 1.0f, z + 1);
        }
        if (metadata == 3) {
            return AABB.getBoundingBoxFromPool(x, y, z, x + 1, (float)y + 1.0f, z + 3);
        }
        if (metadata == 4) {
            return AABB.getBoundingBoxFromPool(x - 2, y, z, x + 1, (float)y + 1.0f, z + 1);
        }
        return AABB.getBoundingBoxFromPool(x, y, z, x + 3, (float)y + 1.0f, z + 1);
    }

    @Override
    public void tick() {
        if (this.worldObj != null && !this.worldObj.isClientSide) {
            List<Entity> list;
            boolean shouldBeActive = false;
            int metadata = this.worldObj.getBlockMetadata(this.x, this.y, this.z);
            if (this.canSeeInFront(this.worldObj, this.x, this.y, this.z) && (list = this.worldObj.getEntitiesWithinAABB(Entity.class, this.getDetectionRadius(this.x, this.y, this.z, metadata))).size() > 0) {
                for (Entity e : list) {
                    Entity entity = e;
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).triggerAchievement(AchievementList.GET_SENSED);
                }
                shouldBeActive = true;
            }
            if (shouldBeActive && this.worldObj.getBlockId(this.x, this.y, this.z) != Block.motionsensorActive.id) {
                this.worldObj.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, "random.breath", 0.5f, this.worldObj.rand.nextFloat());
                BlockMotionSensor.updateSensorBlockState(true, this.worldObj, this.x, this.y, this.z);
            }
            if (!shouldBeActive && this.worldObj.getBlockId(this.x, this.y, this.z) != Block.motionsensorIdle.id) {
                BlockMotionSensor.updateSensorBlockState(false, this.worldObj, this.x, this.y, this.z);
            }
        }
    }
}

