/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet140TileEntityData;

public class TileEntitySign
extends TileEntity {
    public String[] signText = new String[]{"", "", "", ""};
    public int lineBeingEdited = -1;
    private boolean isEditable = true;
    private int selectedPicture = 0;
    private int selectedColor = 15;

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putString("Text1", this.signText[0]);
        tag.putString("Text2", this.signText[1]);
        tag.putString("Text3", this.signText[2]);
        tag.putString("Text4", this.signText[3]);
        tag.putInt("Picture", this.selectedPicture);
        tag.putInt("Color", this.selectedColor);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.isEditable = false;
        super.readFromNBT(tag);
        for (int i = 0; i < 4; ++i) {
            this.signText[i] = tag.getString("Text" + (i + 1));
            if (this.signText[i].length() <= 15) continue;
            this.signText[i] = this.signText[i].substring(0, 15);
        }
        this.selectedPicture = tag.getIntegerOrDefault("Picture", 0);
        this.selectedColor = tag.getIntegerOrDefault("Color", 15);
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsEditable(boolean flag) {
        this.isEditable = flag;
    }

    public EnumSignPicture getPicture() {
        if (this.selectedPicture < 0) {
            return null;
        }
        for (EnumSignPicture picture : EnumSignPicture.values()) {
            if (picture.getId() != this.selectedPicture) continue;
            return picture;
        }
        return null;
    }

    public void setPicture(EnumSignPicture picture) {
        if (picture == null) {
            this.selectedPicture = 0;
            return;
        }
        this.selectedPicture = picture.getId();
    }

    public TextFormatting getColor() {
        if (this.selectedColor < 0 || this.selectedColor > 15) {
            return TextFormatting.BLACK;
        }
        return TextFormatting.FORMATTINGS[this.selectedColor];
    }

    public void setColor(TextFormatting color) {
        this.selectedColor = color.id;
    }

    @Override
    public Packet getDescriptionPacket() {
        return new Packet140TileEntityData(this);
    }
}

