/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.data.gamerule.GameRule;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryBlastFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairableStackable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class Registries
extends Registry<Registry<?>> {
    public static final Registry<WorldType> WORLD_TYPES = new Registry();
    public static final Registry<Biome> BIOMES = new Registry();
    public static final Registry<GameRule<?>> GAME_RULES = new Registry();
    public static final Registry<Class<? extends RecipeEntryBase<?, ?, ?>>> RECIPE_TYPES = new Registry();
    public static final Registry<List<ItemStack>> ITEM_GROUPS = new Registry();
    public static RecipeRegistry RECIPES;
    public static RecipeRegistry RECIPES_LOCAL_COPY;
    private static Registries INSTANCE;
    public static boolean init;

    public Registries() {
        if (init) {
            return;
        }
        init = true;
        INSTANCE = this;
        this.init();
        this.register("minecraft:world_types", WORLD_TYPES);
        this.register("minecraft:biomes", BIOMES);
        this.register("minecraft:recipe_types", RECIPE_TYPES);
        this.register("minecraft:item_groups", ITEM_GROUPS);
        this.register("minecraft:recipes", RECIPES);
    }

    private void init() {
        WorldTypes.init();
        Biomes.init();
        GameRules.init();
        if (RECIPES == null) {
            new RecipeRegistry();
        }
        RECIPE_TYPES.register("minecraft:crafting/shaped", RecipeEntryCraftingShaped.class);
        RECIPE_TYPES.register("minecraft:crafting/shapeless", RecipeEntryCraftingShapeless.class);
        RECIPE_TYPES.register("minecraft:crafting/label", RecipeEntryLabel.class);
        RECIPE_TYPES.register("minecraft:crafting/label_dye", RecipeEntryLabelDye.class);
        RECIPE_TYPES.register("minecraft:crafting/scrap", RecipeEntryScrap.class);
        RECIPE_TYPES.register("minecraft:crafting/repairable", RecipeEntryRepairable.class);
        RECIPE_TYPES.register("minecraft:crafting/repairable_stackable", RecipeEntryRepairableStackable.class);
        RECIPE_TYPES.register("minecraft:crafting/uses_tool", RecipeEntryCraftingWithTool.class);
        RECIPE_TYPES.register("minecraft:smelting", RecipeEntryFurnace.class);
        RECIPE_TYPES.register("minecraft:smelting/blast", RecipeEntryBlastFurnace.class);
        RECIPE_TYPES.register("minecraft:trommeling", RecipeEntryTrommel.class);
        ITEM_GROUPS.register("minecraft:stones", Registries.stackListOf(Block.stone, Block.basalt, Block.limestone, Block.granite));
        ITEM_GROUPS.register("minecraft:cobblestones", Registries.stackListOf(Block.cobbleStone, Block.cobbleBasalt, Block.cobbleLimestone, Block.cobbleGranite, Block.cobblePermafrost));
        ITEM_GROUPS.register("minecraft:planks", Registries.stackListOf(Block.planksOak, new ItemStack(Block.planksOakPainted, 1, 0), new ItemStack(Block.planksOakPainted, 1, 1), new ItemStack(Block.planksOakPainted, 1, 2), new ItemStack(Block.planksOakPainted, 1, 3), new ItemStack(Block.planksOakPainted, 1, 4), new ItemStack(Block.planksOakPainted, 1, 5), new ItemStack(Block.planksOakPainted, 1, 6), new ItemStack(Block.planksOakPainted, 1, 7), new ItemStack(Block.planksOakPainted, 1, 8), new ItemStack(Block.planksOakPainted, 1, 9), new ItemStack(Block.planksOakPainted, 1, 10), new ItemStack(Block.planksOakPainted, 1, 11), new ItemStack(Block.planksOakPainted, 1, 12), new ItemStack(Block.planksOakPainted, 1, 13), new ItemStack(Block.planksOakPainted, 1, 14), new ItemStack(Block.planksOakPainted, 1, 15)));
        ITEM_GROUPS.register("minecraft:grasses", Registries.stackListOf(Block.grass, Block.grassRetro));
        ITEM_GROUPS.register("minecraft:dirt", Registries.stackListOf(Block.dirt, Block.dirtScorched));
        ITEM_GROUPS.register("minecraft:trommel_dirt", Registries.stackListOf(Block.dirt, Block.dirtScorched, Block.grass, Block.grassRetro, Block.grassScorched, Block.pathDirt, Block.farmlandDirt));
        ITEM_GROUPS.register("minecraft:moss_stones", Registries.stackListOf(Block.mossStone, Block.mossBasalt, Block.mossLimestone, Block.mossGranite));
        ITEM_GROUPS.register("minecraft:logs", Registries.stackListOf(Block.logOak, Block.logPine, Block.logBirch, Block.logCherry, Block.logEucalyptus, Block.logOakMossy));
        ITEM_GROUPS.register("minecraft:leaves", Registries.stackListOf(Block.leavesOak, Block.leavesOakRetro, Block.leavesPine, Block.leavesBirch, Block.leavesCherry, Block.leavesEucalyptus, Block.leavesShrub));
        ITEM_GROUPS.register("minecraft:coal_ores", Registries.stackListOf(Block.oreCoalStone, Block.oreCoalBasalt, Block.oreCoalLimestone, Block.oreCoalGranite));
        ITEM_GROUPS.register("minecraft:iron_ores", Registries.stackListOf(Block.oreIronStone, Block.oreIronBasalt, Block.oreIronLimestone, Block.oreIronGranite));
        ITEM_GROUPS.register("minecraft:gold_ores", Registries.stackListOf(Block.oreGoldStone, Block.oreGoldBasalt, Block.oreGoldLimestone, Block.oreGoldGranite));
        ITEM_GROUPS.register("minecraft:lapis_ores", Registries.stackListOf(Block.oreLapisStone, Block.oreLapisBasalt, Block.oreLapisLimestone, Block.oreLapisGranite));
        ITEM_GROUPS.register("minecraft:redstone_ores", Registries.stackListOf(Block.oreRedstoneStone, Block.oreRedstoneBasalt, Block.oreRedstoneLimestone, Block.oreRedstoneGranite, Block.oreRedstoneGlowingStone, Block.oreRedstoneGlowingBasalt, Block.oreRedstoneGlowingLimestone, Block.oreRedstoneGlowingGranite));
        ITEM_GROUPS.register("minecraft:diamond_ores", Registries.stackListOf(Block.oreDiamondStone, Block.oreDiamondBasalt, Block.oreDiamondLimestone, Block.oreDiamondGranite));
        ITEM_GROUPS.register("minecraft:nethercoal_ores", Registries.stackListOf(Block.oreNethercoalNetherrack));
        ITEM_GROUPS.register("minecraft:chests", Registries.stackListOf(Block.chestPlanksOak, new ItemStack(Block.chestPlanksOakPainted, 1, 0), new ItemStack(Block.chestPlanksOakPainted, 1, 16), new ItemStack(Block.chestPlanksOakPainted, 1, 32), new ItemStack(Block.chestPlanksOakPainted, 1, 48), new ItemStack(Block.chestPlanksOakPainted, 1, 64), new ItemStack(Block.chestPlanksOakPainted, 1, 80), new ItemStack(Block.chestPlanksOakPainted, 1, 96), new ItemStack(Block.chestPlanksOakPainted, 1, 112), new ItemStack(Block.chestPlanksOakPainted, 1, 128), new ItemStack(Block.chestPlanksOakPainted, 1, 144), new ItemStack(Block.chestPlanksOakPainted, 1, 160), new ItemStack(Block.chestPlanksOakPainted, 1, 176), new ItemStack(Block.chestPlanksOakPainted, 1, 192), new ItemStack(Block.chestPlanksOakPainted, 1, 208), new ItemStack(Block.chestPlanksOakPainted, 1, 224), new ItemStack(Block.chestPlanksOakPainted, 1, 240)));
        ITEM_GROUPS.register("minecraft:wools", Registries.stackListOf(new ItemStack(Block.wool, 1, 0), new ItemStack(Block.wool, 1, 1), new ItemStack(Block.wool, 1, 2), new ItemStack(Block.wool, 1, 3), new ItemStack(Block.wool, 1, 4), new ItemStack(Block.wool, 1, 5), new ItemStack(Block.wool, 1, 6), new ItemStack(Block.wool, 1, 7), new ItemStack(Block.wool, 1, 8), new ItemStack(Block.wool, 1, 9), new ItemStack(Block.wool, 1, 10), new ItemStack(Block.wool, 1, 11), new ItemStack(Block.wool, 1, 12), new ItemStack(Block.wool, 1, 13), new ItemStack(Block.wool, 1, 14), new ItemStack(Block.wool, 1, 15)));
        ITEM_GROUPS.register("minecraft:lamps", Registries.stackListOf(new ItemStack(Block.lampIdle, 1, 0), new ItemStack(Block.lampIdle, 1, 1), new ItemStack(Block.lampIdle, 1, 2), new ItemStack(Block.lampIdle, 1, 3), new ItemStack(Block.lampIdle, 1, 4), new ItemStack(Block.lampIdle, 1, 5), new ItemStack(Block.lampIdle, 1, 6), new ItemStack(Block.lampIdle, 1, 7), new ItemStack(Block.lampIdle, 1, 8), new ItemStack(Block.lampIdle, 1, 9), new ItemStack(Block.lampIdle, 1, 10), new ItemStack(Block.lampIdle, 1, 11), new ItemStack(Block.lampIdle, 1, 12), new ItemStack(Block.lampIdle, 1, 13), new ItemStack(Block.lampIdle, 1, 14), new ItemStack(Block.lampIdle, 1, 15)));
    }

    public static List<ItemStack> stackListOf(Object ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object item : items) {
            if (item instanceof Block) {
                list.add(new ItemStack((Block)item));
                continue;
            }
            if (item instanceof Item) {
                list.add(new ItemStack((Item)item));
                continue;
            }
            if (!(item instanceof ItemStack)) continue;
            list.add(new ItemStack((ItemStack)item));
        }
        return list;
    }

    public static Registries getInstance() {
        return INSTANCE;
    }

    static {
        init = false;
    }
}

