/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityTNT
extends Entity {
    public int fuse = 0;

    public EntityTNT(World world) {
        super(world);
        this.blocksBuilding = true;
        this.setSize(0.98f, 0.98f);
        this.heightOffset = this.bbHeight / 2.0f;
    }

    public EntityTNT(World world, double d, double d1, double d2) {
        this(world);
        this.setPos(d, d1, d2);
        float f = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.xd = -MathHelper.sin(f * 3.141593f / 180.0f) * 0.02f;
        this.yd = 0.2f;
        this.zd = -MathHelper.cos(f * 3.141593f / 180.0f) * 0.02f;
        this.fuse = 80;
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return !this.removed;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)0.04f;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
            this.yd *= -0.5;
        }
        if (this.fuse-- <= 0) {
            if (!this.world.isClientSide) {
                this.remove();
                this.explode();
            } else {
                this.remove();
            }
        } else {
            this.world.spawnParticle("smoke", this.x, this.y + 0.5, this.z, 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        float f = 4.0f;
        this.world.createExplosion(null, this.x, this.y, this.z, f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("Fuse", (byte)this.fuse);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.fuse = tag.getByte("Fuse");
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

