/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.EntityWaterAnimal;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntitySquid
extends EntityWaterAnimal {
    public float newPitch = 0.0f;
    public float prevPitch = 0.0f;
    public float newYaw = 0.0f;
    public float prevYaw = 0.0f;
    public float animationProgress = 0.0f;
    public float prevAnimationProgress = 0.0f;
    public float newLimbAngle = 0.0f;
    public float limbAnglePrev = 0.0f;
    private float randomMotionSpeed = 0.0f;
    private float animationVelocity = 0.0f;
    private float field_21079_m = 0.0f;
    private float randomMotionVecX = 0.0f;
    private float randomMotionVecY = 0.0f;
    private float randomMotionVecZ = 0.0f;
    private int tickOutOfWater = 5;

    public EntitySquid(World world) {
        super(world);
        this.isInWater();
        this.skinName = "squid";
        this.setSize(0.95f, 0.95f);
        this.animationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    protected String getHurtSound() {
        return null;
    }

    @Override
    protected String getDeathSound() {
        return null;
    }

    @Override
    protected void dropFewItems() {
        int i = this.random.nextInt(3) + 1;
        for (int j = 0; j < i; ++j) {
            this.spawnAtLocation(new ItemStack(Item.dye, 1, 0), 0.0f);
        }
    }

    @Override
    public boolean isInWater() {
        if (this.world == null) {
            return false;
        }
        boolean flag = this.world.handleMaterialAcceleration(this.bb.expand(0.0, -0.6, 0.0), Material.water, this);
        this.tickOutOfWater = !flag ? ++this.tickOutOfWater : 0;
        return this.tickOutOfWater <= 5;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.prevPitch = this.newPitch;
        this.prevYaw = this.newYaw;
        this.prevAnimationProgress = this.animationProgress;
        this.limbAnglePrev = this.newLimbAngle;
        this.animationProgress += this.animationVelocity;
        if (this.animationProgress > (float)Math.PI * 2) {
            this.animationProgress = 0.0f;
            if (this.random.nextInt(10) == 9) {
                this.animationVelocity = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            if (this.animationProgress < (float)Math.PI) {
                float f = this.animationProgress / (float)Math.PI;
                this.newLimbAngle = MathHelper.sin(f * f * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_21079_m = 1.0f;
                } else {
                    this.field_21079_m *= 0.8f;
                }
            } else {
                this.newLimbAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.field_21079_m *= 0.99f;
            }
            if (!this.isMultiplayerEntity) {
                this.xd = this.randomMotionVecX * this.randomMotionSpeed;
                this.yd = this.randomMotionVecY * this.randomMotionSpeed;
                this.zd = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float horizontalSpeed = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
            this.renderYawOffset += (-((float)Math.atan2(this.xd, this.zd)) * 180.0f / (float)Math.PI - this.renderYawOffset) * 0.1f;
            this.yRot = this.renderYawOffset;
            this.newYaw += (float)Math.PI * this.field_21079_m * 1.5f;
            this.newPitch += (-((float)Math.atan2(horizontalSpeed, this.yd)) * 180.0f / (float)Math.PI - this.newPitch) * 0.1f;
        } else {
            this.newLimbAngle = MathHelper.abs(MathHelper.sin(this.animationProgress)) * (float)Math.PI * 0.25f;
            if (!this.isMultiplayerEntity) {
                this.xd = 0.0;
                this.yd -= 0.08;
                this.yd *= 0.98;
                this.zd = 0.0;
            }
            this.newPitch = (float)((double)this.newPitch + (double)(-90.0f - this.newPitch) * 0.02);
        }
    }

    @Override
    public void trySuffocate() {
        if (this.isAlive() && !this.isUnderLiquid(Material.water) && this.canBreatheUnderwater()) {
            --this.airSupply;
            if (this.airSupply == -20) {
                this.airSupply = 0;
                this.hurt(null, 2, DamageType.DROWN);
            }
            this.remainingFireTicks = 0;
        } else {
            this.airSupply = this.airMaxSupply;
        }
    }

    @Override
    public void moveEntityWithHeading(float moveStrafing, float moveForward) {
        this.move(this.xd, this.yd, this.zd);
    }

    @Override
    protected void updatePlayerActionState() {
        if (this.random.nextInt(50) == 0 || !this.wasInWater || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            float f = this.random.nextFloat() * (float)Math.PI * 2.0f;
            this.randomMotionVecX = MathHelper.cos(f) * 0.2f;
            Block upwardsBlock = this.world.getBlock((int)this.x, (int)this.y + 4, (int)this.z);
            Block downwardsBlock = this.world.getBlock((int)this.x, (int)this.y - 4, (int)this.z);
            boolean isTouchingBlock = this.isTouchingBlock();
            this.randomMotionVecY = isTouchingBlock && this.isInWater() ? 0.1f + this.random.nextFloat() * 0.2f : (upwardsBlock == null || upwardsBlock.blockMaterial != Material.water ? -0.15f + this.random.nextFloat() * 0.2f : (downwardsBlock == null || downwardsBlock.blockMaterial != Material.water ? -0.05f + this.random.nextFloat() * 0.4f : -0.1f + this.random.nextFloat() * 0.2f));
            this.randomMotionVecZ = MathHelper.sin(f) * 0.2f;
        }
        this.tryToDespawn();
    }

    public boolean isTouchingBlock() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX = MathHelper.floor_double(this.bb.minX - 0.25);
        if (this.world.areBlocksLoaded(minX, minY = MathHelper.floor_double(this.bb.minY - 0.25), minZ = MathHelper.floor_double(this.bb.minZ - 0.25), maxX = MathHelper.floor_double(this.bb.maxX + 0.25), maxY = MathHelper.floor_double(this.bb.maxY + 0.25), maxZ = MathHelper.floor_double(this.bb.maxZ + 0.25))) {
            for (int _x = minX; _x <= maxX; ++_x) {
                for (int _y = minY; _y <= maxY; ++_y) {
                    for (int _z = minZ; _z <= maxZ; ++_z) {
                        int blockId = this.world.getBlockId(_x, _y, _z);
                        if (blockId == 0 || Block.blocksList[blockId].blockMaterial == Material.water) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }
}

