/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ArmorMaterial;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pathfinder.Path;

public class EntityWolf
extends EntityAnimal {
    private boolean looksWithInterest = false;
    private float field_25048_b;
    private float field_25054_c;
    private boolean isWolfShaking;
    private boolean field_25052_g;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private ItemStack armor = null;
    private static final Map<ArmorMaterial, ItemArmor> ARMOR_MATERIALS = new HashMap<ArmorMaterial, ItemArmor>();

    public EntityWolf(World world) {
        super(world);
        this.skinName = "wolf";
        this.setSize(0.8f, 0.8f);
        this.moveSpeed = 1.1f;
        this.scoreValue = 500;
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(15, ItemStack.NO_ITEM);
        this.entityData.define(16, (byte)0);
        this.entityData.define(17, "");
        this.entityData.define(19, "");
        if (!this.isWolfTamed() && this.random.nextInt(100) == 0) {
            this.setWolfHeldItem(new ItemStack(Item.recordDog, 1));
        }
    }

    public ArmorMaterial getArmorMaterial() {
        ArmorMaterial material = null;
        String name = this.entityData.getString(19);
        for (ArmorMaterial mat : ArmorMaterial.getArmorMaterials()) {
            if (!mat.name.equalsIgnoreCase(name)) continue;
            material = mat;
            break;
        }
        return material;
    }

    public void setArmor(ItemStack stack) {
        ArmorMaterial material = null;
        this.armor = stack;
        if (stack != null && stack.getItem() instanceof ItemArmor && ARMOR_MATERIALS.containsValue(stack.getItem())) {
            material = ((ItemArmor)stack.getItem()).material;
        }
        if (material == null) {
            this.entityData.set(19, "");
        } else {
            this.entityData.set(19, material.name);
        }
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public String getEntityTexture() {
        if (this.isWolfTamed()) {
            return "/mob/wolf_tame/" + this.getSkinVariant() + ".png";
        }
        if (this.isWolfAngry()) {
            return "/mob/wolf_angry/" + this.getSkinVariant() + ".png";
        }
        return super.getEntityTexture();
    }

    @Override
    public String getDefaultEntityTexture() {
        if (this.isWolfTamed()) {
            return "/mob/wolf_tame/0.png";
        }
        if (this.isWolfAngry()) {
            return "/mob/wolf_angry/0.png";
        }
        return super.getEntityTexture();
    }

    @Override
    public boolean collidesWith(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            return !player.username.equalsIgnoreCase(this.getWolfOwner()) || this.isWolfSitting();
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Angry", this.isWolfAngry());
        tag.putBoolean("Sitting", this.isWolfSitting());
        if (this.getWolfHeldItem() != null) {
            CompoundTag heldItemNBT = new CompoundTag();
            this.getWolfHeldItem().writeToNBT(heldItemNBT);
            tag.putCompound("HeldItem", heldItemNBT);
        }
        if (this.getArmorMaterial() != null) {
            CompoundTag armorTag = new CompoundTag();
            this.armor.writeToNBT(armorTag);
            tag.putCompound("Armor", armorTag);
        }
        if (this.getWolfOwner() == null) {
            tag.putString("Owner", "");
        } else {
            tag.putString("Owner", this.getWolfOwner());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        String s;
        ItemStack stack;
        super.readAdditionalSaveData(tag);
        this.setWolfAngry(tag.getBoolean("Angry"));
        this.setWolfSitting(tag.getBoolean("Sitting"));
        CompoundTag heldItemStack = tag.getCompound("HeldItem");
        if (heldItemStack != null && (stack = ItemStack.readItemStackFromNbt(heldItemStack)) != null) {
            this.setWolfHeldItem(stack);
        }
        if (tag.containsKey("Armor")) {
            ArmorMaterial material = null;
            String name = tag.getString("Armor");
            if (!name.isEmpty()) {
                for (ArmorMaterial mat : ArmorMaterial.getArmorMaterials()) {
                    if (!mat.name.equalsIgnoreCase(name)) continue;
                    material = mat;
                    break;
                }
                Item item = ARMOR_MATERIALS.get(material);
                this.setArmor(item.getDefaultStack());
            } else {
                CompoundTag armorTag = tag.getCompound("Armor");
                ItemStack armor = ItemStack.readItemStackFromNbt(armorTag);
                this.setArmor(armor);
            }
        }
        if (!(s = tag.getString("Owner")).isEmpty()) {
            this.setWolfOwner(s);
            this.setWolfTamed(true);
        }
    }

    @Override
    protected boolean canDespawn() {
        return !this.isWolfTamed() && super.canDespawn();
    }

    @Override
    public String getLivingSound() {
        if (this.isWolfAngry()) {
            return "mob.wolf.growl";
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isWolfTamed() && this.getHealth() < this.getMaxHealth() / 2) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    @Override
    protected String getHurtSound() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return -1;
    }

    @Override
    protected void dropFewItems() {
        if (this.getHeldItem() != null && this.getHeldItem().stackSize > 0) {
            this.spawnAtLocation(this.getHeldItem(), 0.0f);
            this.setWolfHeldItem(null);
        }
        if (this.armor != null && this.armor.stackSize > 0) {
            this.spawnAtLocation(this.armor, 0.0f);
            this.setArmor(null);
        }
    }

    @Override
    protected void updatePlayerActionState() {
        List<Entity> nearbySheep;
        super.updatePlayerActionState();
        if (this.getTarget() instanceof EntityItem && (this.getTarget().isInWater() || this.getTarget().isInLava() || this.getTarget().isInWall())) {
            this.setTarget(null);
        }
        if (!this.hasAttacked && !this.hasPath() && this.isWolfTamed() && this.vehicle == null) {
            EntityPlayer entityplayer = this.world.getPlayerEntityByName(this.getWolfOwner());
            if (entityplayer != null) {
                float f = entityplayer.distanceTo(this);
                if (f > 5.0f) {
                    this.getPathOrWalkableBlock(entityplayer, f);
                }
            } else if (!this.isInWater()) {
                this.setWolfSitting(true);
            }
        } else if (!(this.entityToAttack != null || this.hasPath() || this.isWolfTamed() || this.world.rand.nextInt(100) != 0 || (nearbySheep = this.world.getEntitiesWithinAABB(EntitySheep.class, AABB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).expand(16.0, 4.0, 16.0))).isEmpty())) {
            this.setTarget(nearbySheep.get(this.world.rand.nextInt(nearbySheep.size())));
        }
        ItemStack heldItemSlot = this.getWolfHeldItem();
        if (heldItemSlot == null || heldItemSlot.itemID <= 0) {
            ArrayList<EntityItem> triedItems = new ArrayList<EntityItem>();
            List<Entity> nearbyItems = this.world.getEntitiesWithinAABB(EntityItem.class, AABB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).expand(16.0, 4.0, 16.0));
            if (!nearbyItems.isEmpty()) {
                while (triedItems.size() != nearbyItems.size()) {
                    EntityItem item = (EntityItem)nearbyItems.get(this.world.rand.nextInt(nearbyItems.size()));
                    if (triedItems.contains(item)) continue;
                    if (item.isInWater() || item.isInLava() || item.isInWall()) {
                        triedItems.add(item);
                        continue;
                    }
                    this.setTarget(item);
                    break;
                }
            }
        }
        if (this.isInWater()) {
            this.setWolfSitting(false);
        }
    }

    @Override
    public void onLivingUpdate() {
        Entity entity;
        super.onLivingUpdate();
        this.looksWithInterest = false;
        if (this.hasCurrentTarget() && !this.hasPath() && !this.isWolfAngry() && (entity = this.getCurrentTarget()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null) {
                if (!this.isWolfTamed() && itemstack.itemID == Item.bone.id) {
                    this.looksWithInterest = true;
                } else if (this.isWolfTamed() && Item.itemsList[itemstack.itemID] instanceof ItemFood) {
                    this.looksWithInterest = ((ItemFood)Item.itemsList[itemstack.itemID]).getIsWolfsFavoriteMeat();
                }
            }
        }
        if (!this.isMultiplayerEntity && this.isWolfShaking && !this.field_25052_g && !this.hasPath() && this.onGround) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.world.sendTrackedEntityStatusUpdatePacket(this, (byte)8);
        }
    }

    @Override
    public ItemStack getHeldItem() {
        return this.getWolfHeldItem();
    }

    @Override
    public void tick() {
        super.tick();
        List<Entity> entitiesNearWolf = this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb);
        if (entitiesNearWolf != null && entitiesNearWolf.size() > 0) {
            for (Entity entity : entitiesNearWolf) {
                if (!(entity instanceof EntityItem) || this.getWolfHeldItem() != null && this.getWolfHeldItem().getItem() != null) continue;
                EntityItem entityItem = (EntityItem)entity;
                if (entityItem.item == null || entityItem.item.stackSize <= 0) continue;
                this.setWolfHeldItem(entityItem.item.copy());
                entityItem.item.stackSize = 0;
                entity.outOfWorld();
                break;
            }
        }
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            this.numTicksToChaseTarget = 10;
        }
        if (this.isInWaterOrRain()) {
            this.isWolfShaking = true;
            this.field_25052_g = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWolfShaking || this.field_25052_g) && this.field_25052_g) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.world.playSoundAtEntity(null, this, "mob.wolf.shake", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWolfShaking = false;
                this.field_25052_g = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.bb.minY;
                int i = (int)(MathHelper.sin((this.timeWolfIsShaking - 0.4f) * 3.141593f) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth * 0.5f;
                    float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth * 0.5f;
                    this.world.spawnParticle("splash", this.x + (double)f1, f + 0.8f, this.z + (double)f2, this.xd, this.yd, this.zd);
                }
            }
        }
    }

    public boolean getWolfShaking() {
        return this.isWolfShaking;
    }

    public float getShadingWhileShaking(float f) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * f) / 2.0f * 0.25f;
    }

    public float getShakeAngle(float f, float f1) {
        float f2 = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * f + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.sin(f2 * 3.141593f) * MathHelper.sin(f2 * 3.141593f * 11.0f) * 0.15f * 3.141593f;
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    @Override
    public float getHeadHeight() {
        return this.bbHeight * 0.8f;
    }

    @Override
    protected int func_25026_x() {
        if (this.isWolfSitting()) {
            return 20;
        }
        return super.func_25026_x();
    }

    private void getPathOrWalkableBlock(Entity entity, float f) {
        Path pathentity = this.world.getPathToEntity(this, entity, 16.0f);
        if (pathentity == null && f > 12.0f) {
            int i = MathHelper.floor_double(entity.x) - 2;
            int j = MathHelper.floor_double(entity.z) - 2;
            int k = MathHelper.floor_double(entity.bb.minY);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.world.isBlockNormalCube(i + l, k - 1, j + i1) || this.world.isBlockNormalCube(i + l, k, j + i1) || this.world.isBlockNormalCube(i + l, k + 1, j + i1)) continue;
                    this.moveTo((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.yRot, this.xRot);
                    return;
                }
            }
        } else {
            this.setPathToEntity(pathentity);
        }
    }

    @Override
    protected boolean isMovementCeased() {
        return this.isWolfSitting() || this.field_25052_g;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        this.setWolfSitting(false);
        if (attacker != null && !(attacker instanceof EntityPlayer) && !(attacker instanceof EntityArrow)) {
            i = (i + 1) / 2;
        }
        if (super.hurt(attacker, i, type)) {
            if (!this.isWolfTamed() && !this.isWolfAngry()) {
                if (attacker instanceof EntityPlayer) {
                    this.setWolfAngry(true);
                    this.entityToAttack = attacker;
                }
                if (attacker instanceof EntityArrow && ((EntityArrow)attacker).owner != null) {
                    attacker = ((EntityArrow)attacker).owner;
                }
                if (attacker instanceof EntityLiving) {
                    List<Entity> list = this.world.getEntitiesWithinAABB(EntityWolf.class, AABB.getBoundingBoxFromPool(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0).expand(16.0, 4.0, 16.0));
                    for (Entity entity1 : list) {
                        EntityWolf entitywolf = (EntityWolf)entity1;
                        if (entitywolf.isWolfTamed() || entitywolf.entityToAttack != null) continue;
                        entitywolf.entityToAttack = attacker;
                        if (!(attacker instanceof EntityPlayer)) continue;
                        entitywolf.setWolfAngry(true);
                    }
                }
            } else if (attacker != this && attacker != null) {
                if (this.isWolfTamed() && attacker instanceof EntityPlayer && ((EntityPlayer)attacker).username.equalsIgnoreCase(this.getWolfOwner())) {
                    return true;
                }
                this.entityToAttack = attacker;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Entity findPlayerToAttack() {
        if (this.isWolfAngry()) {
            return this.world.getClosestPlayerToEntity(this, 16.0);
        }
        return null;
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (distance > 2.0f && distance < 6.0f && this.random.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.x - this.x;
                double d1 = entity.z - this.z;
                float f1 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.xd = d / (double)f1 * 0.5 * (double)0.8f + this.xd * (double)0.2f;
                this.zd = d1 / (double)f1 * 0.5 * (double)0.8f + this.zd * (double)0.2f;
                this.yd = 0.4f;
            }
        } else if ((double)distance < 1.5 && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            this.attackTime = 20;
            int byte0 = 2;
            if (this.isWolfTamed()) {
                byte0 = 4;
            }
            entity.hurt(this, byte0, DamageType.COMBAT);
        }
    }

    @Override
    protected void damageEntity(int damage, DamageType damageType) {
        if (this.getArmorMaterial() == null) {
            super.damageEntity(damage, damageType);
            return;
        }
        float protection = 1.0f - this.getArmorMaterial().getProtection(damageType);
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        super.damageEntity(newDamage, damageType);
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (!this.isWolfTamed()) {
            if (itemstack != null && itemstack.itemID == Item.bone.id && !this.isWolfAngry()) {
                itemstack.consumeItem(entityplayer);
                if (itemstack.stackSize <= 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                if (!this.world.isClientSide) {
                    if (this.random.nextInt(3) == 0) {
                        this.setWolfTamed(true);
                        this.setPathToEntity(null);
                        this.setWolfSitting(true);
                        this.setHealthRaw(this.getMaxHealth());
                        this.setWolfOwner(entityplayer.username);
                        this.showHeartsOrSmokeFX(true);
                        this.world.sendTrackedEntityStatusUpdatePacket(this, (byte)7);
                    } else {
                        this.showHeartsOrSmokeFX(false);
                        this.world.sendTrackedEntityStatusUpdatePacket(this, (byte)6);
                    }
                }
                return true;
            }
        } else {
            ItemFood itemfood;
            if (itemstack != null && Item.itemsList[itemstack.itemID] instanceof ItemFood && (itemfood = (ItemFood)Item.itemsList[itemstack.itemID]).getIsWolfsFavoriteMeat() && this.getHealth() < this.getMaxHealth()) {
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                    if (itemstack.stackSize <= 0) {
                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                    }
                }
                this.heal(((ItemFood)Item.foodPorkchopRaw).getHealAmount());
                return true;
            }
            if (itemstack != null && itemstack.getItem() != null && itemstack.getItem() instanceof ItemArmor && entityplayer.username.equalsIgnoreCase(this.getWolfOwner())) {
                ItemArmor itemArmor = (ItemArmor)itemstack.getItem();
                if (itemArmor.material != null && ARMOR_MATERIALS.containsValue(itemArmor)) {
                    if (this.armor != null) {
                        this.spawnAtLocation(this.armor, 0.0f);
                        this.setArmor(null);
                    }
                    this.setArmor(new ItemStack(itemstack.getItem(), 1, itemstack.getMetadata(), itemstack.getData()));
                    if (entityplayer.getGamemode().consumeBlocks()) {
                        --itemstack.stackSize;
                        if (itemstack.stackSize <= 0) {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }
                    }
                    return true;
                }
            }
            if (entityplayer.username.equalsIgnoreCase(this.getWolfOwner())) {
                if (!this.world.isClientSide) {
                    ItemStack heldItemSlot = this.getWolfHeldItem();
                    if (this.isWolfSitting() && heldItemSlot != null && heldItemSlot.getItem() != null && heldItemSlot.itemID > 0 && !entityplayer.isSneaking()) {
                        entityplayer.inventory.insertItem(heldItemSlot, true);
                        if (heldItemSlot.stackSize <= 0) {
                            this.setWolfHeldItem(null);
                        }
                    } else {
                        this.setWolfSitting(!this.isWolfSitting());
                        this.isJumping = false;
                        this.setPathToEntity(null);
                    }
                }
                return true;
            }
        }
        return false;
    }

    void showHeartsOrSmokeFX(boolean flag) {
        String s = "heart";
        if (!flag) {
            s = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.world.spawnParticle(s, this.x + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, this.y + 0.5 + (double)(this.random.nextFloat() * this.bbHeight), this.z + (double)(this.random.nextFloat() * this.bbWidth * 2.0f) - (double)this.bbWidth, d, d1, d2);
        }
    }

    @Override
    public int getMaxHealth() {
        if (this.isWolfTamed()) {
            return 20;
        }
        return 8;
    }

    @Override
    public void handleEntityEvent(byte byte0, float attackedAtYaw) {
        if (byte0 == 7) {
            this.showHeartsOrSmokeFX(true);
        } else if (byte0 == 6) {
            this.showHeartsOrSmokeFX(false);
        } else if (byte0 == 8) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.handleEntityEvent(byte0, attackedAtYaw);
        }
    }

    public float getTailRotation() {
        if (this.isWolfAngry()) {
            return 1.5358897f;
        }
        if (this.isWolfTamed()) {
            return (0.55f - (float)(this.getMaxHealth() - this.getHealth()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    public String getWolfOwner() {
        return this.entityData.getString(17);
    }

    public void setWolfOwner(String s) {
        this.entityData.set(17, s);
    }

    public boolean isWolfSitting() {
        return (this.entityData.getByte(16) & 1) != 0;
    }

    public void setWolfSitting(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (byte)(byte0 | 1));
        } else {
            this.entityData.set(16, (byte)(byte0 & 0xFFFFFFFE));
        }
    }

    public boolean isWolfAngry() {
        return (this.entityData.getByte(16) & 2) != 0;
    }

    public void setWolfAngry(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (byte)(byte0 | 2));
        } else {
            this.entityData.set(16, (byte)(byte0 & 0xFFFFFFFD));
        }
    }

    public ItemStack getWolfHeldItem() {
        ItemStack stack = this.entityData.getItemStack(15);
        if (stack == ItemStack.NO_ITEM) {
            stack = null;
        }
        return stack;
    }

    public void setWolfHeldItem(ItemStack itemStack) {
        if (itemStack == null) {
            itemStack = ItemStack.NO_ITEM;
        }
        this.entityData.set(15, itemStack);
    }

    public boolean isWolfTamed() {
        return (this.entityData.getByte(16) & 4) != 0;
    }

    public void setWolfTamed(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (byte)(byte0 | 4));
        } else {
            this.entityData.set(16, (byte)(byte0 & 0xFFFFFFFB));
        }
    }

    static {
        ARMOR_MATERIALS.put(ArmorMaterial.LEATHER, (ItemArmor)Item.armorChestplateLeather);
        ARMOR_MATERIALS.put(ArmorMaterial.CHAINMAIL, (ItemArmor)Item.armorChestplateChainmail);
        ARMOR_MATERIALS.put(ArmorMaterial.IRON, (ItemArmor)Item.armorChestplateIron);
        ARMOR_MATERIALS.put(ArmorMaterial.GOLD, (ItemArmor)Item.armorChestplateGold);
        ARMOR_MATERIALS.put(ArmorMaterial.DIAMOND, (ItemArmor)Item.armorChestplateDiamond);
        ARMOR_MATERIALS.put(ArmorMaterial.STEEL, (ItemArmor)Item.armorChestplateSteel);
    }
}

