/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.world.World;

public class EntityWombat
extends EntityMonster {
    public EntityWombat(World world) {
        super(world);
        this.skinName = "wombat";
        this.setSize(0.9f, 0.9f);
        this.fireImmune = true;
    }

    @Override
    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.world.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer) && entityplayer.getGamemode().areMobsHostile()) {
            return entityplayer;
        }
        Entity otherEntity = this.world.getClosestEntityToEntity(this, 16.0);
        if (!(otherEntity instanceof EntityWombat)) {
            return otherEntity;
        }
        return null;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 128;
    }

    @Override
    protected float getBlockPathWeight(int i, int j, int k) {
        return 1.0f;
    }

    @Override
    public boolean getCanSpawnHere() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(17, (byte)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.entityData.getByte(17) == 1) {
            tag.putBoolean("powered", true);
        }
    }

    @Override
    public String getEntityTexture() {
        if (this.getPowered()) {
            return "/mob/wombat_powered/0.png";
        }
        return "/mob/wombat/0.png";
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPowered(tag.getBoolean("powered"));
    }

    @Override
    public String getLivingSound() {
        return "mob.zombiepig.zpigangry";
    }

    @Override
    protected String getHurtSound() {
        return "mob.wolf.growl";
    }

    @Override
    protected String getDeathSound() {
        return "mob.ghast.scream";
    }

    @Override
    public void playLivingSound() {
        String s = this.getLivingSound();
        if (s != null) {
            this.world.playSoundAtEntity(null, this, s, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.05f + 0.25f);
        }
    }

    @Override
    public void playHurtSound() {
        this.world.playSoundAtEntity(null, this, this.getHurtSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.05f + 0.25f);
    }

    @Override
    public void playDeathSound() {
        this.world.playSoundAtEntity(null, this, this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.05f + 0.25f);
    }

    @Override
    public void onDeath(Entity entity) {
        super.onDeath(entity);
        this.world.addWeatherEffect(new EntityLightningBolt(this.world, this.x, this.y, this.z));
    }

    public boolean getPowered() {
        return this.entityData.getByte(17) == 1;
    }

    public void setPowered(boolean powered) {
        this.entityData.set(17, (byte)(powered ? 1 : 0));
        if (powered) {
            this.moveSpeed = 1.5f;
        }
    }

    @Override
    public void thunderHit(EntityLightningBolt bolt) {
        super.thunderHit(bolt);
        this.setPowered(true);
    }
}

