/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.monster.IEnemy;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class EntitySlime
extends EntityLiving
implements IEnemy {
    public float field_768_a;
    public float field_767_b;
    private int slimeJumpDelay = 0;
    private boolean hasSlimeSplit;
    private boolean sizeSet = false;

    public EntitySlime(World world) {
        super(world);
        this.skinName = "slime";
        this.heightOffset = 0.0f;
        this.slimeJumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = false;
    }

    public EntitySlime(World world, boolean isSplit) {
        super(world);
        this.skinName = "slime";
        this.heightOffset = 0.0f;
        this.slimeJumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = isSplit;
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)1);
    }

    @Override
    public void spawnInit() {
        super.init();
        if (!this.hasSlimeSplit) {
            int size = this.random.nextInt(3) + 1;
            if (size == 3) {
                size = 4;
            }
            this.setSlimeSize(size);
        }
    }

    public void setSlimeSize(int i) {
        this.entityData.set(16, (byte)i);
        this.setSize(0.5f * (float)i, 0.5f * (float)i);
        this.setHealthRaw(this.getMaxHealth());
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public int getMaxHealth() {
        return this.getSlimeSize() * this.getSlimeSize();
    }

    public int getSlimeSize() {
        return this.entityData.getByte(16);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Size", this.getSlimeSize() - 1);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSlimeSize(tag.getInteger("Size") + 1);
    }

    @Override
    public void tick() {
        if (!this.sizeSet) {
            this.setSlimeSize(this.getSlimeSize());
            this.sizeSet = true;
        }
        this.field_767_b = this.field_768_a;
        boolean flag = this.onGround;
        super.tick();
        if (this.onGround && !flag) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.random.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.random.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin(f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.cos(f) * (float)i * 0.5f * f1;
                this.world.spawnParticle("item", this.x + (double)f2, this.bb.minY, this.z + (double)f3, Item.slimeball.id, 0.0, 0.0);
            }
            if (i > 2) {
                this.world.playSoundAtEntity(null, this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_768_a = -0.5f;
        }
        if (!this.world.isClientSide && this.world.difficultySetting == 0) {
            this.remove();
        }
        this.field_768_a *= 0.6f;
    }

    @Override
    protected void updatePlayerActionState() {
        boolean targetPlayer;
        this.tryToDespawn();
        EntityPlayer entityplayer = this.world.getClosestPlayerToEntity(this, 16.0);
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile();
        if (entityplayer != null && targetPlayer) {
            this.faceEntity(entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            if (!targetPlayer) {
                float rotation = (this.world.rand.nextFloat() - 0.5f) * 90.0f;
                this.yRot += rotation;
            }
            this.slimeJumpDelay = this.random.nextInt(20) + 10;
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.world.playSoundAtEntity(null, this, "mob.slime", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_768_a = 1.0f;
            this.moveStrafing = 1.0f - this.random.nextFloat() * 2.0f;
            this.moveForward = this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    @Override
    public void remove() {
        int size = this.getSlimeSize();
        if (!this.world.isClientSide && size > 1 && this.getHealth() <= 0) {
            int splitCount = this.world.rand.nextInt(4) + 1;
            for (int j = 0; j < splitCount; ++j) {
                float f = ((float)(j % 2) - 0.5f) * (float)size / 4.0f;
                float f1 = ((float)(j / 2) - 0.5f) * (float)size / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.world, true);
                entityslime.setSlimeSize(size / 2);
                entityslime.moveTo(this.x + (double)f, this.y + 0.5, this.z + (double)f1, this.random.nextFloat() * 360.0f, 0.0f);
                this.world.entityJoinedWorld(entityslime);
            }
        }
        super.remove();
    }

    @Override
    public void playerTouch(EntityPlayer player) {
        int i = this.getSlimeSize();
        if (i > 1 && this.canEntityBeSeen(player) && (double)this.distanceTo(player) < 0.6 * (double)i && player.hurt(this, i, DamageType.COMBAT)) {
            this.world.playSoundAtEntity(null, this, "mob.slimeattack", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.slime";
    }

    @Override
    protected String getDeathSound() {
        return "mob.slime";
    }

    @Override
    protected int getDropItemId() {
        if (this.getSlimeSize() == 1) {
            return Item.slimeball.id;
        }
        return 0;
    }

    @Override
    public boolean getCanSpawnHere() {
        Chunk chunk = this.world.getChunkFromBlockCoords(MathHelper.floor_double(this.x), MathHelper.floor_double(this.z));
        if (this.y > 32.0) {
            return false;
        }
        if (chunk.getChunkRandom(987234911L).nextInt(10) != 0) {
            return false;
        }
        if (this.world.difficultySetting == 0) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    @Override
    protected float getSoundVolume() {
        return 0.6f;
    }
}

