/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;

public class EntitySnowman
extends EntityMonster {
    public EntitySnowman(World world) {
        super(world);
        this.skinName = "snowman";
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.scoreValue = 300;
    }

    @Override
    public void onLivingUpdate() {
        float f;
        if (this.world.isDaytime() && (f = this.getBrightness(1.0f)) > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && (this.world.getCurrentWeather() != Weather.overworldFog || this.world.weatherManager.getWeatherPower() < 0.75f) && this.world.getCurrentWeather() != Weather.overworldSnow && this.world.getCurrentWeather() != Weather.overworldWinterSnow) {
            this.remainingFireTicks = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        if (distance < 8.0f && distance > 4.0f) {
            double dX = entity.x - this.x;
            double dZ = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    EntitySnowball snowball = new EntitySnowball(this.world, this);
                    if (this.world.getBlockId((int)this.x, (int)this.y - 1, (int)this.z) == Block.gravel.id) {
                        snowball.damage = 1;
                    }
                    snowball.y += 1.4;
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - snowball.y;
                    float f1 = MathHelper.sqrt_double(dX * dX + dZ * dZ) * 0.2f;
                    this.world.playSoundAtEntity(null, this, "random.bow", 0.5f, 0.4f / (this.random.nextFloat() * 0.4f + 0.8f));
                    this.world.entityJoinedWorld(snowball);
                    snowball.setHeadingPrecise(dX, d2 + (double)f1, dZ, 0.6f);
                }
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(dZ, dX) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        } else if (distance <= 4.0f) {
            super.attackEntity(entity, distance);
        }
    }

    @Override
    public boolean getCanSpawnHere() {
        int x = (int)this.x;
        int y = (int)this.y;
        int z = (int)this.z;
        Biome biome = this.world.getBlockBiome(x, y, z);
        return !(!super.getCanSpawnHere() || !this.world.canBlockSeeTheSky(x, y, z) || biome != Biomes.OVERWORLD_GLACIER && (this.world.seasonManager.getCurrentSeason() != Seasons.OVERWORLD_WINTER && this.world.seasonManager.getCurrentSeason() != Seasons.OVERWORLD_WINTER_ENDLESS || this.world.getCurrentWeather() != Weather.overworldSnow && this.world.getCurrentWeather() != Weather.overworldWinterSnow));
    }

    @Override
    public String getLivingSound() {
        return "mob.zombie";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    @Override
    protected int getDropItemId() {
        return Item.ammoSnowball.id;
    }
}

