/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntityMonster;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntitySpider
extends EntityMonster {
    public EntitySpider(World world) {
        super(world);
        this.skinName = "spider";
        this.setSize(1.4f, 0.9f);
        this.moveSpeed = 0.8f;
        this.scoreValue = 200;
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)1);
    }

    @Override
    public void spawnInit() {
        super.init();
        if (this.world.difficultySetting != 0 && this.random.nextInt(100 / this.world.difficultySetting) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.world);
            entityskeleton.moveTo(this.x, this.y, this.z, this.yRot, 0.0f);
            this.world.entityJoinedWorld(entityskeleton);
            entityskeleton.startRiding(this);
        }
    }

    @Override
    public double getRideHeight() {
        return (double)this.bbHeight * 0.75 - 0.5;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected Entity findPlayerToAttack() {
        float f = this.getBrightness(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            EntityPlayer p = this.world.getClosestPlayerToEntity(this, d);
            if (p != null && !p.gamemode.areMobsHostile()) {
                return null;
            }
            return p;
        }
        return null;
    }

    @Override
    public String getLivingSound() {
        return "mob.spider";
    }

    @Override
    protected String getHurtSound() {
        return "mob.spider";
    }

    @Override
    protected String getDeathSound() {
        return "mob.spiderdeath";
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        float brightness = this.getBrightness(1.0f);
        if (brightness > 0.5f && this.random.nextInt(100) == 0) {
            this.entityToAttack = null;
            return;
        }
        if (distance > 2.0f && distance < 6.0f && this.random.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.x - this.x;
                double d1 = entity.z - this.z;
                float f2 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.xd = d / (double)f2 * 0.5 * (double)0.8f + this.xd * (double)0.2f;
                this.zd = d1 / (double)f2 * 0.5 * (double)0.8f + this.zd * (double)0.2f;
                this.yd = 0.4f;
            }
        } else {
            super.attackEntity(entity, distance);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    protected int getDropItemId() {
        return Item.string.id;
    }

    @Override
    public boolean canClimb() {
        return this.horizontalCollision;
    }
}

