/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityProjectile;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityArrow
extends EntityProjectile {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int inTile = 0;
    public int shake = 0;
    protected int inData = 0;
    protected boolean inGround = false;
    public boolean doesArrowBelongToPlayer;
    protected int arrowType;
    protected ItemStack stack = new ItemStack(Item.ammoArrow);

    public EntityArrow(World world) {
        this(world, 0);
    }

    public EntityArrow(World world, int arrowType) {
        super(world);
        this.doesArrowBelongToPlayer = false;
        this.arrowType = arrowType;
    }

    public EntityArrow(World world, double d, double d1, double d2, int arrowType) {
        super(world, d, d1, d2);
        this.doesArrowBelongToPlayer = false;
        this.arrowType = arrowType;
    }

    public EntityArrow(World world, EntityLiving entityliving, boolean doesArrowBelongToPlayer, int arrowType) {
        super(world, entityliving);
        this.doesArrowBelongToPlayer = doesArrowBelongToPlayer;
        this.arrowType = arrowType;
    }

    @Override
    protected void init() {
        super.init();
        this.damage = 5;
        if (!(this.owner instanceof EntityPlayer)) {
            this.doesArrowBelongToPlayer = false;
        }
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt_double(xd * xd + zd * zd);
            this.yRot = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(yd, f) * 180.0 / Math.PI);
            this.yRotO = this.yRot;
            this.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
            this.ticksInGround = 0;
        }
    }

    @Override
    public void tick() {
        Block block;
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
            this.yRotO = this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
            this.xRotO = this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / 3.1415927410125732);
        }
        if ((block = this.world.getBlock(this.xTile, this.yTile, this.zTile)) != null) {
            block.setBlockBoundsBasedOnState(this.world, this.xTile, this.yTile, this.zTile);
            AABB axisalignedbb = block.getCollisionBoundingBoxFromPool(this.world, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3d.createVector(this.x, this.y, this.z))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            int id = this.world.getBlockId(this.xTile, this.yTile, this.zTile);
            int meta = this.world.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            if (id != this.inTile || meta != this.inData) {
                this.inGround = false;
                this.xd *= (double)(this.random.nextFloat() * 0.2f);
                this.yd *= (double)(this.random.nextFloat() * 0.2f);
                this.zd *= (double)(this.random.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
                return;
            }
            ++this.ticksInGround;
            if (this.ticksInGround == 1200) {
                this.remove();
            }
            return;
        }
        if (this instanceof EntityArrowGolden) {
            this.world.spawnParticle("arrowtrail", this.x, this.y, this.z, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f);
            this.world.spawnParticle("arrowtrail", this.x + this.xd * 0.5, this.y + this.yd * 0.5, this.z + this.zd * 0.5, this.xd * (double)0.05f, this.yd * (double)0.05f - (double)0.1f, this.zd * (double)0.05f);
        }
        super.tick();
    }

    @Override
    public HitResult getHitResult() {
        Vec3d oldPosition = Vec3d.createVector(this.x, this.y, this.z);
        Vec3d newPosition = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd);
        return this.world.checkBlockCollisionBetweenPoints(oldPosition, newPosition, false, true);
    }

    @Override
    public void onHit(HitResult hitResult) {
        if (hitResult.entity != null) {
            if (hitResult.entity.hurt(this.owner, this.damage, DamageType.COMBAT)) {
                if (this.isOnFire()) {
                    hitResult.entity.fireHurt();
                }
                if (!this.world.isClientSide) {
                    this.world.playSoundAtEntity(null, this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                }
                if (!(this instanceof EntityArrowGolden)) {
                    this.remove();
                }
            } else if (!(this instanceof EntityArrowGolden)) {
                this.xd *= -0.1;
                this.yd *= -0.1;
                this.zd *= -0.1;
                this.yRot += 180.0f;
                this.yRotO += 180.0f;
                this.ticksInAir = 0;
            }
        } else {
            this.xTile = hitResult.x;
            this.yTile = hitResult.y;
            this.zTile = hitResult.z;
            this.inTile = this.world.getBlockId(this.xTile, this.yTile, this.zTile);
            this.inData = this.world.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            this.xd = (float)(hitResult.location.xCoord - this.x);
            this.yd = (float)(hitResult.location.yCoord - this.y);
            this.zd = (float)(hitResult.location.zCoord - this.z);
            float f1 = MathHelper.sqrt_double(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
            this.x -= this.xd / (double)f1 * 0.05;
            this.y -= this.yd / (double)f1 * 0.05;
            this.z -= this.zd / (double)f1 * 0.05;
            this.inGroundAction();
        }
    }

    protected void inGroundAction() {
        if (!this.world.isClientSide) {
            this.world.playSoundAtEntity(null, this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        }
        this.inGround = true;
        this.shake = 7;
    }

    public int getArrowType() {
        return this.arrowType;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putShort("xTile", (short)this.xTile);
        tag.putShort("yTile", (short)this.yTile);
        tag.putShort("zTile", (short)this.zTile);
        tag.putShort("inTile", (short)this.inTile);
        tag.putByte("shake", (byte)this.shake);
        tag.putByte("inData", (byte)this.inData);
        tag.putByte("inGround", (byte)(this.inGround ? 1 : 0));
        tag.putBoolean("player", this.doesArrowBelongToPlayer);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.xTile = tag.getShort("xTile");
        this.yTile = tag.getShort("yTile");
        this.zTile = tag.getShort("zTile");
        this.inTile = tag.getShort("inTile") & 0x3FFF;
        this.shake = tag.getByte("shake") & 0xFF;
        this.inData = tag.getByte("inData") & 0xFF;
        this.inGround = tag.getByte("inGround") == 1;
        this.doesArrowBelongToPlayer = tag.getBoolean("player");
    }

    @Override
    public void playerTouch(EntityPlayer player) {
        if (this.world.isClientSide) {
            return;
        }
        if (this.inGround && this.doesArrowBelongToPlayer && this.shake <= 0) {
            player.inventory.insertItem(this.stack, true);
            if (this.stack.stackSize <= 0) {
                this.world.playSoundAtEntity(null, this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.onItemPickup(this, this.stack.itemID);
                this.remove();
            }
        }
    }
}

