/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockWool;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldTypes;

public class ItemDye
extends Item {
    public static final String[] dyeColors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightblue", "magenta", "orange", "white"};
    public static final int[] field_31002_bk = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 2651799, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public ItemDye(String name, int id) {
        super(name, id);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return super.getKey() + "." + dyeColors[itemstack.getMetadata()];
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(blockX, blockY, blockZ) == Block.signPostPlanksOak.id || world.getBlockId(blockX, blockY, blockZ) == Block.signWallPlanksOak.id) {
            TileEntitySign sign = (TileEntitySign)world.getBlockTileEntity(blockX, blockY, blockZ);
            if (15 - itemstack.getMetadata() != sign.getColor().id) {
                sign.setColor(TextFormatting.get(15 - itemstack.getMetadata()));
                if (entityplayer.getGamemode().consumeBlocks()) {
                    --itemstack.stackSize;
                }
                return true;
            }
            return false;
        }
        if (itemstack.getMetadata() == 15) {
            int id = world.getBlockId(blockX, blockY, blockZ);
            Block block = Block.blocksList[id];
            if (block instanceof IBonemealable && ((IBonemealable)((Object)block)).onBonemealUsed(itemstack, entityplayer, world, blockX, blockY, blockZ, side, xPlaced, yPlaced)) {
                return true;
            }
            if (id == Block.dirt.id) {
                if (!world.isClientSide && Block.lightBlock[world.getBlockId(blockX, blockY + 1, blockZ)] <= 2) {
                    int grass = Block.grass.id;
                    if (world.dimensionData.getWorldType() == WorldTypes.OVERWORLD_RETRO) {
                        grass = Block.grassRetro.id;
                    }
                    world.setBlockWithNotify(blockX, blockY, blockZ, grass);
                    if (entityplayer.getGamemode().consumeBlocks()) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (id == Block.dirtScorched.id) {
                if (!world.isClientSide && Block.lightBlock[world.getBlockId(blockX, blockY + 1, blockZ)] <= 2) {
                    int grass = Block.grassScorched.id;
                    world.setBlockWithNotify(blockX, blockY, blockZ, grass);
                    if (entityplayer.getGamemode().consumeBlocks()) {
                        --itemstack.stackSize;
                    }
                }
                return true;
            }
            if (Block.blocksList[id] != null && Block.blocksList[id].hasTag(BlockTags.GROWS_FLOWERS)) {
                if (!world.isClientSide) {
                    if (entityplayer.getGamemode().consumeBlocks()) {
                        --itemstack.stackSize;
                    }
                    block0: for (int j1 = 0; j1 < 128; ++j1) {
                        int k1 = blockX;
                        int l1 = blockY + 1;
                        int i2 = blockZ;
                        for (int j2 = 0; j2 < j1 / 16; ++j2) {
                            int id1 = world.getBlockId(k1 += itemRand.nextInt(3) - 1, (l1 += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2) - 1, i2 += itemRand.nextInt(3) - 1);
                            if (Block.blocksList[id1] == null || !Block.blocksList[id1].hasTag(BlockTags.GROWS_FLOWERS)) continue block0;
                        }
                        if (world.getBlockId(k1, l1, i2) != 0) continue;
                        if (itemRand.nextInt(10) != 0) {
                            if (world.getBlockId(k1, l1 - 1, i2) == Block.dirtScorched.id || world.getBlockId(k1, l1 - 1, i2) == Block.dirtScorchedRich.id) {
                                world.setBlockWithNotify(k1, l1, i2, Block.spinifex.id);
                                continue;
                            }
                            world.setBlockWithNotify(k1, l1, i2, Block.tallgrass.id);
                            continue;
                        }
                        if (itemRand.nextInt(3) != 0) {
                            world.setBlockWithNotify(k1, l1, i2, Block.flowerYellow.id);
                            continue;
                        }
                        world.setBlockWithNotify(k1, l1, i2, Block.flowerRed.id);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useItemOnEntity(ItemStack itemstack, EntityLiving entityliving, EntityPlayer entityPlayer) {
        if (entityliving instanceof EntitySheep) {
            EntitySheep entitysheep = (EntitySheep)entityliving;
            int i = BlockWool.func_21034_c(itemstack.getMetadata());
            if (entitysheep.getFleeceColor() != i && itemstack.consumeItem(entityPlayer)) {
                entitysheep.setFleeceColor(i);
                return true;
            }
        }
        return false;
    }
}

