/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class ItemFood
extends Item {
    protected int healAmount;
    protected boolean isWolfsFavoriteMeat;

    public ItemFood(String name, int id, int healAmount, boolean favouriteWolfMeat) {
        super(name, id);
        this.healAmount = healAmount;
        this.isWolfsFavoriteMeat = favouriteWolfMeat;
        this.maxStackSize = 1;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.getHealth() < entityplayer.getMaxHealth() && itemstack.consumeItem(entityplayer)) {
            entityplayer.heal(this.healAmount);
        }
        return itemstack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public boolean getIsWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }
}

