/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockJukeBox;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemRecord
extends Item {
    public final String recordName;

    protected ItemRecord(String name, int id, String s) {
        super(name, id);
        this.recordName = s;
        this.maxStackSize = 1;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(blockX, blockY, blockZ) == Block.jukebox.id && world.getBlockMetadata(blockX, blockY, blockZ) == 0) {
            if (!world.isClientSide) {
                ((BlockJukeBox)Block.jukebox).playRecord(world, blockX, blockY, blockZ, this.id);
                world.playSoundEffect(null, 1005, blockX, blockY, blockZ, this.id);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }
}

