/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import net.minecraft.core.Global;
import net.minecraft.core.lang.Language;

public class LanguageSeeker {
    public static final File LANGUAGE_DIR = Global.accessor.getMinecraftDir().toPath().resolve("languages").toFile();

    public static Language seek(String id) throws IOException {
        File[] files;
        if (id.equals("en_US")) {
            return Language.Default.INSTANCE;
        }
        Language ret = null;
        if (LANGUAGE_DIR.exists() && LANGUAGE_DIR.isDirectory() && (files = LANGUAGE_DIR.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".zip")) continue;
                ZipFile zip = new ZipFile(file);
                try (InputStream stream = zip.getInputStream(zip.getEntry("lang_info.json"));){
                    String content = LanguageSeeker.readInputString(stream);
                    JsonObject json = JsonParser.instance.parseString(content);
                    String langId = json.getString("id");
                    String langName = json.getString("name");
                    String langRegion = json.getString("region");
                    JsonArray array = json.getArray("credits");
                    ArrayList<String> langCredits = new ArrayList<String>();
                    for (JsonElement element : array) {
                        String string = element.getAsString().toString();
                        if (string == null) continue;
                        langCredits.add(string);
                    }
                    if (langId == null || langName == null || langCredits.isEmpty() || !langId.equals(id)) continue;
                    ret = new Language(id, langName, langRegion, langCredits, zip);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ret;
    }

    public static List<Language> getAvailableLanguages() throws IOException {
        File[] files;
        ArrayList<Language> ret = new ArrayList<Language>();
        ret.add(Language.Default.INSTANCE);
        if (LANGUAGE_DIR.exists() && LANGUAGE_DIR.isDirectory() && (files = LANGUAGE_DIR.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".zip")) continue;
                ZipFile zip = new ZipFile(file);
                try (InputStream stream = zip.getInputStream(zip.getEntry("lang_info.json"));){
                    String content = LanguageSeeker.readInputString(stream);
                    JsonObject json = JsonParser.instance.parseString(content);
                    String langId = json.getString("id");
                    String langName = json.getString("name");
                    String langRegion = json.getString("region");
                    JsonArray array = json.getArray("credits");
                    ArrayList<String> langCredits = new ArrayList<String>();
                    for (JsonElement element : array) {
                        String string = element.getAsString().toString();
                        if (string == null) continue;
                        langCredits.add(string);
                    }
                    ret.add(new Language(langId, langName, langRegion, langCredits, zip));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static String readInputString(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            String line = null;
            boolean firstLine = true;
            while ((line = br.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    line = "\n" + line;
                }
                builder.append(line);
            }
            br.close();
            reader.close();
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

