/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;

public class BiomeCommand
extends Command {
    public BiomeCommand() {
        super("biome", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0 && sender instanceof PlayerCommandSender) {
            EntityPlayer p = sender.getPlayer();
            World world = p.world;
            Biome biome = world.getBlockBiome((int)p.x, (int)p.y, (int)p.z);
            sender.sendMessage("Current biome: " + Registries.BIOMES.getKey(biome));
            return true;
        }
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("list")) {
                sender.sendMessage("Biomes:");
                for (Biome biome : Registries.BIOMES) {
                    String key = Registries.BIOMES.getKey(biome);
                    if (args.length != 1 && (args.length != 2 || !key.startsWith(args[1]))) continue;
                    sender.sendMessage(" - " + Registries.BIOMES.getKey(biome));
                }
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("locate") && sender instanceof PlayerCommandSender) {
                Biome biome = Registries.BIOMES.getItem(args[1]);
                if (biome == null) {
                    sender.sendMessage("Unknown biome: " + args[1]);
                } else {
                    int[] nearest = this.getBiomeCoords(biome, sender.getPlayer());
                    if (nearest == null) {
                        sender.sendMessage("No biome found!");
                    } else {
                        sender.sendMessage("Biome located at: " + nearest[0] + ", " + nearest[1]);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/biome");
        }
        sender.sendMessage("/biome list [filter]");
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/biome locate <biome>");
        }
    }

    private int[] getBiomeCoords(Biome biome, EntityPlayer source) {
        int[] xPattern = new int[]{0, 1, 0, -1};
        int[] zPattern = new int[]{1, 0, -1, 0};
        int runLength = 2;
        int chunkX = (int)(source.x / 16.0);
        int y = (int)source.y;
        int chunkZ = (int)(source.z / 16.0);
        int passes = 1024;
        if (source.world.getBlockBiome(chunkX * 16, y, chunkZ * 16) == biome) {
            return new int[]{chunkX * 16, chunkZ * 16};
        }
        --chunkX;
        --chunkZ;
        for (int pass = 0; pass < passes; ++pass) {
            for (int i = 0; i < 4; ++i) {
                for (int j = runLength - 1; j >= 0; --j) {
                    if (source.world.getBlockBiome((chunkX += xPattern[i]) * 16, y, (chunkZ += zPattern[i]) * 16) != biome) continue;
                    return new int[]{chunkX * 16, chunkZ * 16};
                }
            }
            ++runLength;
        }
        return null;
    }
}

