/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.net.ChatEmotes;

public class EmotesCommand
extends ServerCommand {
    public EmotesCommand(MinecraftServer server) {
        super(server, "emotes", ":");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        sender.sendMessage("Emotes:");
        ArrayList<Map.Entry<String, Character>> entryList = new ArrayList<Map.Entry<String, Character>>(ChatEmotes.getEmotes().entrySet());
        entryList.sort(Map.Entry.comparingByKey());
        for (Map.Entry<String, Character> entry : entryList) {
            sender.sendMessage(" - " + TextFormatting.CYAN + entry.getKey().substring(1, entry.getKey().length() - 1) + TextFormatting.RESET + " -> " + entry.getValue());
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/emotes");
        sender.sendMessage("/:");
    }
}

