/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;

public class WeatherCommand
extends Command {
    public WeatherCommand() {
        super("weather", "w");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equals("list")) {
            StringBuilder weatherString = new StringBuilder();
            weatherString.append(TextFormatting.LIGHT_GRAY + "Available weathers: " + TextFormatting.WHITE);
            weatherString.append("clear");
            for (Weather weather : Weather.weatherList) {
                if (weather == null) continue;
                weatherString.append(", ");
                weatherString.append(weather.languageKey.substring(8));
            }
            sender.sendMessage(weatherString.toString());
            return true;
        }
        if (sender.isPlayer()) {
            EntityPlayer player = sender.getPlayer();
            if (args[0].equals("next")) {
                player.world.weatherManager.skip();
                handler.sendCommandFeedback(sender, "Skipping to next weather");
                return true;
            }
            if (args[0].equals("set")) {
                int dimension = player.dimension;
                Long duration = null;
                Weather weather = null;
                Float power = null;
                World world = null;
                if (handler instanceof ServerCommandHandler) {
                    ServerCommandHandler server = (ServerCommandHandler)handler;
                    world = server.minecraftServer.dimensionWorlds[dimension];
                }
                if (handler instanceof ClientCommandHandler) {
                    ClientCommandHandler client = (ClientCommandHandler)handler;
                    world = client.minecraft.theWorld;
                }
                if (world == null) {
                    return false;
                }
                weather = WeatherCommand.getWeather(args[1], world);
                if (weather == null) {
                    throw new CommandError("Weather \"" + args[1] + "\" doesn't exist!");
                }
                if (args.length >= 3) {
                    duration = Long.parseLong(args[2]) * 20L;
                }
                if (args.length >= 4) {
                    power = Float.valueOf(Float.parseFloat(args[3]));
                }
                if (duration != null && power != null) {
                    world.weatherManager.overrideWeather(weather, duration, power.floatValue());
                } else if (duration != null) {
                    world.weatherManager.overrideWeather(weather, duration);
                } else {
                    world.weatherManager.overrideWeather(weather);
                }
                handler.sendCommandFeedback(sender, TextFormatting.LIGHT_GRAY + "Changing weather to " + TextFormatting.WHITE + weather.getLanguageKey().substring(8));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/weather list");
        if (sender.isPlayer()) {
            sender.sendMessage("/weather next");
            sender.sendMessage("/weather set <weather> [duration (sec)] [power (0.0-1.0)]");
        }
    }

    public static Weather getWeather(String string, World world) {
        try {
            return Weather.getWeather(Integer.parseInt(string));
        }
        catch (Exception exception) {
            try {
                if (string.equalsIgnoreCase("clear")) {
                    Weather w = world.worldType.getDefaultWeather();
                    if (w == null) {
                        throw new CommandError("Dimension " + world.dimension.getTranslatedName() + " does not have a default weather!");
                    }
                    return w;
                }
                return Weather.getWeatherByLanguageKey(string);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

