/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.Direction;

public class Packet135PlacementMode
extends Packet {
    public Direction rotation;
    public Direction rotationHorizontal;
    public Direction rotationVertical;
    public PlacementMode placementMode;

    public Packet135PlacementMode() {
    }

    public Packet135PlacementMode(Direction d, Direction dx, Direction dy, PlacementMode placementMode) {
        this.rotation = d;
        this.rotationHorizontal = dx;
        this.rotationVertical = dy;
        this.placementMode = placementMode;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.rotation = Packet135PlacementMode.readDirection(dis);
        this.rotationHorizontal = Packet135PlacementMode.readDirection(dis);
        this.rotationVertical = Packet135PlacementMode.readDirection(dis);
        this.placementMode = Packet135PlacementMode.readPlacementMode(dis);
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        Packet135PlacementMode.writeDirection(dos, this.rotation);
        Packet135PlacementMode.writeDirection(dos, this.rotationHorizontal);
        Packet135PlacementMode.writeDirection(dos, this.rotationVertical);
        Packet135PlacementMode.writePlacementMode(dos, this.placementMode);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePlacementMode(this);
    }

    @Override
    public int getPacketSize() {
        return 4;
    }

    public static Direction readDirection(DataInputStream dataInputStream) throws IOException {
        return Direction.getDirectionById(dataInputStream.readByte());
    }

    public static void writeDirection(DataOutputStream dataOutputStream, Direction direction) throws IOException {
        if (direction != null) {
            dataOutputStream.writeByte(direction.getId());
        } else {
            dataOutputStream.writeByte(-1);
        }
    }

    public static void writePlacementMode(DataOutputStream dataOutputStream, PlacementMode placementMode) throws IOException {
        if (placementMode != null) {
            dataOutputStream.writeByte(placementMode.index());
        } else {
            dataOutputStream.writeByte(-1);
        }
    }

    public static PlacementMode readPlacementMode(DataInputStream dataInputStream) throws IOException {
        return PlacementMode.get(dataInputStream.readByte());
    }
}

