/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;

public class Packet20NamedEntitySpawn
extends Packet {
    public int entityId;
    public String name;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public int currentItem;
    public String nickname;
    public byte chatColor;

    public Packet20NamedEntitySpawn() {
    }

    public Packet20NamedEntitySpawn(EntityPlayer entityplayer) {
        this.entityId = entityplayer.id;
        this.name = entityplayer.username;
        this.xPosition = MathHelper.floor_double(entityplayer.x * 32.0);
        this.yPosition = MathHelper.floor_double(entityplayer.y * 32.0);
        this.zPosition = MathHelper.floor_double(entityplayer.z * 32.0);
        this.rotation = (byte)(entityplayer.yRot * 256.0f / 360.0f);
        this.pitch = (byte)(entityplayer.xRot * 256.0f / 360.0f);
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.currentItem = itemstack != null ? itemstack.itemID : 0;
        this.nickname = entityplayer.nickname;
        this.chatColor = entityplayer.chatColor;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.name = Packet20NamedEntitySpawn.readString(dis, 16);
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.rotation = dis.readByte();
        this.pitch = dis.readByte();
        this.currentItem = dis.readShort();
        this.nickname = Packet20NamedEntitySpawn.readString(dis, 32);
        this.chatColor = dis.readByte();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        Packet20NamedEntitySpawn.writeString(this.name, dos);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeByte(this.rotation);
        dos.writeByte(this.pitch);
        dos.writeShort(this.currentItem);
        Packet20NamedEntitySpawn.writeString(this.nickname, dos);
        dos.writeByte(this.chatColor);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleNamedEntitySpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 28;
    }
}

