/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;

public class Packet23VehicleSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public float pitch;
    public float yaw;
    public int field_28047_e;
    public int field_28046_f;
    public int field_28045_g;
    public int type;
    public int field_28044_i;
    public int arrowType;

    public Packet23VehicleSpawn() {
    }

    public Packet23VehicleSpawn(Entity entity, int i) {
        this(entity, i, 0);
    }

    public Packet23VehicleSpawn(Entity entity, int i, int j) {
        this.entityId = entity.id;
        this.xPosition = MathHelper.floor_double(entity.x * 32.0);
        this.yPosition = MathHelper.floor_double(entity.y * 32.0);
        this.zPosition = MathHelper.floor_double(entity.z * 32.0);
        this.pitch = entity.xRot;
        this.yaw = entity.yRot;
        this.type = i;
        this.field_28044_i = j;
        if (j > 0) {
            double d = entity.xd;
            double d1 = entity.yd;
            double d2 = entity.zd;
            double d3 = 3.9;
            if (d < -d3) {
                d = -d3;
            }
            if (d1 < -d3) {
                d1 = -d3;
            }
            if (d2 < -d3) {
                d2 = -d3;
            }
            if (d > d3) {
                d = d3;
            }
            if (d1 > d3) {
                d1 = d3;
            }
            if (d2 > d3) {
                d2 = d3;
            }
            this.field_28047_e = (int)(d * 8000.0);
            this.field_28046_f = (int)(d1 * 8000.0);
            this.field_28045_g = (int)(d2 * 8000.0);
        }
        if (entity instanceof EntityArrow) {
            this.arrowType = ((EntityArrow)entity).getArrowType();
        }
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.type = dis.readByte();
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.pitch = dis.readFloat();
        this.yaw = dis.readFloat();
        this.field_28044_i = dis.readInt();
        if (this.field_28044_i > 0) {
            this.field_28047_e = dis.readShort();
            this.field_28046_f = dis.readShort();
            this.field_28045_g = dis.readShort();
        }
        if (this.type == 60) {
            this.arrowType = dis.readInt();
        }
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeByte(this.type);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeFloat(this.pitch);
        dos.writeFloat(this.yaw);
        dos.writeInt(this.field_28044_i);
        if (this.field_28044_i > 0) {
            dos.writeShort(this.field_28047_e);
            dos.writeShort(this.field_28046_f);
            dos.writeShort(this.field_28045_g);
        }
        if (this.type == 60 || this.type == 73) {
            dos.writeInt(this.arrowType);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleVehicleSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 21 + this.field_28044_i <= 0 ? 0 : 6;
    }
}

