/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.crafting.ICrafting;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.InventoryPlayer;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotFurnace;

public class ContainerFurnace
extends Container {
    public TileEntityFurnace tileEntity;
    private int currentCookTime = 0;
    private int currentBurnTime = 0;
    private int itemBurnTime = 0;
    private int itemCookTime = 0;

    public ContainerFurnace(InventoryPlayer inventoryplayer, TileEntityFurnace tileentityfurnace) {
        this.tileEntity = tileentityfurnace;
        this.addSlot(new Slot(tileentityfurnace, 0, 56, 17));
        this.addSlot(new Slot(tileentityfurnace, 1, 56, 53));
        this.addSlot(new SlotFurnace(inventoryplayer.player, tileentityfurnace, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot(inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot(inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void updateInventory() {
        super.updateInventory();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.currentCookTime != this.tileEntity.currentCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 0, this.tileEntity.currentCookTime);
            }
            if (this.currentBurnTime != this.tileEntity.currentBurnTime) {
                icrafting.updateCraftingInventoryInfo(this, 1, this.tileEntity.currentBurnTime);
            }
            if (this.itemCookTime != this.tileEntity.maxCookTime) {
                icrafting.updateCraftingInventoryInfo(this, 2, this.tileEntity.maxCookTime);
            }
            if (this.itemBurnTime == this.tileEntity.maxBurnTime) continue;
            icrafting.updateCraftingInventoryInfo(this, 3, this.tileEntity.maxBurnTime);
        }
        this.currentCookTime = this.tileEntity.currentCookTime;
        this.currentBurnTime = this.tileEntity.currentBurnTime;
        this.itemCookTime = this.tileEntity.maxCookTime;
        this.itemBurnTime = this.tileEntity.maxBurnTime;
    }

    @Override
    public void updateClientProgressBar(int id, int value) {
        if (id == 0) {
            this.tileEntity.currentCookTime = value;
        }
        if (id == 1) {
            this.tileEntity.currentBurnTime = value;
        }
        if (id == 2) {
            this.tileEntity.maxCookTime = value;
        }
        if (id == 3) {
            this.tileEntity.maxBurnTime = value;
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.tileEntity.canInteractWith(entityplayer);
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= 0 && slot.id <= 3) {
            return this.getSlots(slot.id, 1, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.id >= 3 && slot.id <= 30) {
                return this.getSlots(3, 27, false);
            }
            if (slot.id >= 30 && slot.id <= 38) {
                return this.getSlots(30, 9, false);
            }
        }
        if (slot.id >= 3 && slot.id <= 38) {
            return this.getSlots(3, 36, false);
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= 3 && slot.id <= 39) {
            if (action != InventoryAction.MOVE_ALL) {
                if (target == 1) {
                    return this.getSlots(0, 1, false);
                }
                if (target == 2) {
                    return this.getSlots(1, 1, false);
                }
            }
            if (slot.id >= 3 && slot.id <= 29) {
                return this.getSlots(30, 9, false);
            }
            if (slot.id >= 31 && slot.id <= 38) {
                return this.getSlots(3, 27, false);
            }
        }
        if (slot.id >= 0 && slot.id <= 2) {
            if (slot.id == 2) {
                return this.getSlots(3, 36, true);
            }
            return this.getSlots(3, 36, false);
        }
        return null;
    }
}

