/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.slot;

import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.player.inventory.ContainerPlayer;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.slot.Slot;

public class SlotArmor
extends Slot {
    final int armorType;
    final ContainerPlayer inventory;

    public SlotArmor(ContainerPlayer containerplayer, IInventory iinventory, int i, int j, int k, int l) {
        super(iinventory, i, j, k);
        this.inventory = containerplayer;
        this.armorType = l;
    }

    @Override
    public int getSlotStackLimit() {
        return 1;
    }

    @Override
    public boolean canPutStackInSlot(ItemStack itemstack) {
        if (itemstack.getItem() instanceof ItemArmor) {
            return ((ItemArmor)itemstack.getItem()).armorPiece == this.armorType;
        }
        if (itemstack.getItem() instanceof ItemBlock) {
            return this.armorType == 0;
        }
        if (itemstack.getItem().id == Item.armorQuiverGold.id || itemstack.getItem().id == Item.armorQuiver.id) {
            return this.armorType == 1;
        }
        if (itemstack.getItem().id == Item.armorBootsIceskates.id) {
            return this.armorType == 3;
        }
        return false;
    }

    @Override
    public void onSlotChanged() {
        super.onSlotChanged();
        int count = 0;
        for (int i = 0; i < this.inventory.inventorySlots.size(); ++i) {
            ItemStack stack;
            if (!(this.inventory.inventorySlots.get(i) instanceof SlotArmor) || (stack = ((Slot)this.inventory.inventorySlots.get(i)).getStack()) == null || stack.itemID != Item.armorBootsChainmail.id && stack.itemID != Item.armorHelmetChainmail.id && stack.itemID != Item.armorChestplateChainmail.id && stack.itemID != Item.armorLeggingsChainmail.id) continue;
            ++count;
        }
        if (count == 4) {
            this.inventory.playerInv.player.triggerAchievement(AchievementList.GET_CHAINMAIL);
        }
    }

    @Override
    public int getBackgroundIconIndex() {
        return ItemModelStandard.iconCoordToIndex(15, this.armorType);
    }
}

