/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.noise.ImprovedNoise;

public class AuroraProvider {
    private final ImprovedNoise noise;
    private final World world;

    public AuroraProvider(World world, long seed) {
        this.world = world;
        this.noise = new ImprovedNoise(new Random(seed));
    }

    public float getAuroraPresence(float x, float z, long worldTime, float celestialAngle) {
        float auroraLevel = 0.0f;
        float auroraRadius = 0.03f;
        float mult = 1.0f;
        if (celestialAngle < 0.25f || celestialAngle > 0.75f) {
            return 0.0f;
        }
        celestialAngle = (celestialAngle - 0.25f) * 2.0f;
        celestialAngle = celestialAngle * 2.0f - 1.0f;
        celestialAngle = Math.abs(celestialAngle);
        mult = celestialAngle = -celestialAngle + 1.0f;
        float sample = (float)this.noise.getValue(x / 1000.0f, (float)worldTime / 5000.0f, z / 1000.0f);
        if ((sample += (float)this.noise.getValue(x / 30.0f, (float)worldTime / 50.0f, z / 30.0f) * 0.05f) < auroraLevel - auroraRadius || sample > auroraLevel + auroraRadius) {
            return 0.0f;
        }
        sample -= auroraLevel;
        sample /= auroraRadius;
        sample = Math.abs(sample);
        sample = -sample;
        return (sample += 1.0f) * mult;
    }

    public float getAuroraHeightOffset(float x, float z, float worldTime) {
        float sample = (float)this.noise.getValue(x / 100.0f, worldTime / 5000.0f, z / 100.0f) * 25.0f;
        return sample;
    }

    public float getAuroraRedOffset(float x, float z, float worldTime) {
        float sample = (float)this.noise.getValue(x / 500.0f, worldTime / 5000.0f + 10000.0f, z / 500.0f);
        float sample2 = (float)this.noise.getValue(x / 200.0f, worldTime / 5000.0f, z / 200.0f);
        if (sample < 0.0f) {
            sample = 0.0f;
        }
        if (sample > 0.25f) {
            sample = 0.25f;
        }
        if (sample2 < 0.0f) {
            sample2 = 0.0f;
        }
        if (sample2 > 0.1f) {
            sample2 = 0.1f;
        }
        return sample * 3.0f + sample2 * 2.0f;
    }

    public float getAuroraGreenOffset(float x, float z, float worldTime) {
        float sample = (float)this.noise.getValue(x / 500.0f, worldTime / 5000.0f + 10000.0f, z / 500.0f);
        float sample2 = (float)this.noise.getValue(x / 500.0f, worldTime / 5000.0f, z / 500.0f);
        if (sample < 0.0f) {
            sample = 0.0f;
        }
        if (sample > 0.125f) {
            sample = 0.125f;
        }
        if (sample2 < 0.0f) {
            sample2 = 0.0f;
        }
        if (sample2 > 0.25f) {
            sample2 = 0.25f;
        }
        return sample * 4.0f - sample2 * 2.0f;
    }

    public float getAuroraBlueOffset(float x, float z, float worldTime) {
        float sample = (float)this.noise.getValue(x / 500.0f, worldTime / 5000.0f, z / 500.0f);
        if (sample < 0.0f) {
            sample = 0.0f;
        }
        if (sample > 0.25f) {
            sample = 0.25f;
        }
        return sample;
    }
}

