/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.CompoundTag;
import java.util.Map;
import net.minecraft.core.data.legacy.LegacyBiomes;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;

public class ChunkReaderLegacy
extends ChunkReader {
    public ChunkReaderLegacy(World world, CompoundTag tag) {
        super(world, tag);
    }

    @Override
    public int getX() {
        return this.tag.getInteger("xPos");
    }

    @Override
    public int getZ() {
        return this.tag.getInteger("zPos");
    }

    @Override
    public short[] getBlocks(int ySection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkUnsignedByteArray getData(int ySection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkNibbleArray getSkyLight(int ySection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkNibbleArray getBlockLight(int ySection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] getHeightMap() {
        return this.tag.getShortArrayOrDefault("HeightMap", null);
    }

    @Override
    public int getAverageBlockHeight() {
        return this.tag.getInteger("AverageBlockHeight");
    }

    @Override
    public boolean getIsTerrainPopulated() {
        return this.tag.getBoolean("TerrainPopulated");
    }

    @Override
    public double[] getTemperatureMap() {
        return this.tag.getDoubleArray("TemperatureMap");
    }

    @Override
    public double[] getHumidityMap() {
        return this.tag.getDoubleArray("HumidityMap");
    }

    @Override
    public byte[] getBiomeMap(int ySection, Map<Integer, String> biomeRegistry) {
        byte[] oldBiomes = this.tag.getByteArray("BiomeMap");
        byte[] newBiomes = new byte[oldBiomes.length];
        for (int i = 0; i < oldBiomes.length; ++i) {
            byte newBiomeId;
            byte oldBiomeId = oldBiomes[i];
            newBiomes[i] = oldBiomeId < 0 ? oldBiomeId : (newBiomeId = (byte)Registries.BIOMES.getNumericIdOfItem(LegacyBiomes.getBiomeById(oldBiomeId)));
        }
        return newBiomes;
    }

    @Override
    public Map<Integer, String> getBiomeRegistry() {
        return null;
    }
}

