/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk.reader;

import com.mojang.nbt.CompoundTag;
import java.util.Map;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkSection;
import net.minecraft.core.world.chunk.reader.ChunkReader;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.data.ChunkUnsignedByteArray;

public class ChunkReaderVersion1
extends ChunkReader {
    private final short[] blocks;
    private final byte[] data;
    private final byte[] skylight;
    private final byte[] blocklight;
    private final byte[] biome;

    private static int makeChunkIndex(int x, int y, int z) {
        return x * 16 * 256 + z * 256 + y;
    }

    public static int makeBiomeIndex(int x, int y, int z) {
        return (y >> 3) * 16 * 16 + x * 16 + z;
    }

    private static int makeNibbleIndex(int x, int y, int z) {
        return x * 16 * 256 + z * 256 + y;
    }

    public ChunkReaderVersion1(World world, CompoundTag tag) {
        super(world, tag);
        this.blocks = tag.getShortArrayOrDefault("Blocks", null);
        this.data = tag.getByteArrayOrDefault("Data", null);
        this.skylight = tag.getByteArrayOrDefault("SkyLight", null);
        this.blocklight = tag.getByteArrayOrDefault("BlockLight", null);
        this.biome = tag.getByteArrayOrDefault("BiomeMap", null);
    }

    @Override
    public int getX() {
        return this.tag.getInteger("xPos");
    }

    @Override
    public int getZ() {
        return this.tag.getInteger("zPos");
    }

    @Override
    public short[] getBlocks(int ySection) {
        short[] newBlocks = new short[4096];
        if (this.blocks != null && ChunkReaderVersion1.makeChunkIndex(15, ySection * 16 + 15, 15) < this.blocks.length) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        short id;
                        int yOffset = ySection * 16;
                        newBlocks[ChunkSection.makeBlockIndex((int)x, (int)y, (int)z)] = id = this.blocks[ChunkReaderVersion1.makeChunkIndex(x, yOffset + y, z)];
                    }
                }
            }
        }
        return newBlocks;
    }

    @Override
    public ChunkUnsignedByteArray getData(int ySection) {
        byte[] newData = new byte[4096];
        ChunkUnsignedByteArray array = new ChunkUnsignedByteArray(16, 16, 16, newData);
        if (this.data != null && ChunkReaderVersion1.makeChunkIndex(15, ySection * 16 + 15, 15) < this.data.length) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int yOffset = ySection * 16;
                        byte data = this.data[ChunkReaderVersion1.makeChunkIndex(x, yOffset + y, z)];
                        array.set(x, y, z, Byte.toUnsignedInt(data));
                    }
                }
            }
        }
        return array;
    }

    @Override
    public ChunkNibbleArray getSkyLight(int ySection) {
        byte[] newSkyLight = new byte[2048];
        ChunkNibbleArray array = new ChunkNibbleArray(16, 16, 16, newSkyLight);
        if (this.skylight != null && ChunkReaderVersion1.makeNibbleIndex(15, ySection * 16 + 15, 15) < this.skylight.length * 2) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int yOffset = ySection * 16;
                        int index = ChunkReaderVersion1.makeNibbleIndex(x, yOffset + y, z);
                        int nibbleIndex = index >> 1;
                        int nibblePart = index & 1;
                        int nibble = nibblePart == 0 ? Byte.toUnsignedInt(this.skylight[nibbleIndex]) & 0xF : Byte.toUnsignedInt(this.skylight[nibbleIndex]) >> 4 & 0xF;
                        array.set(x, y, z, nibble);
                    }
                }
            }
        }
        return array;
    }

    @Override
    public ChunkNibbleArray getBlockLight(int ySection) {
        byte[] newBlockLight = new byte[2048];
        ChunkNibbleArray array = new ChunkNibbleArray(16, 16, 16, newBlockLight);
        if (this.blocklight != null && ChunkReaderVersion1.makeNibbleIndex(15, ySection * 16 + 15, 15) < this.blocklight.length * 2) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        int yOffset = ySection * 16;
                        int index = ChunkReaderVersion1.makeNibbleIndex(x, yOffset + y, z);
                        int nibbleIndex = index >> 1;
                        int nibblePart = index & 1;
                        int nibble = nibblePart == 0 ? Byte.toUnsignedInt(this.blocklight[nibbleIndex]) & 0xF : Byte.toUnsignedInt(this.blocklight[nibbleIndex]) >> 4 & 0xF;
                        array.set(x, y, z, nibble);
                    }
                }
            }
        }
        return array;
    }

    @Override
    public short[] getHeightMap() {
        return this.tag.getShortArrayOrDefault("HeightMap", null);
    }

    @Override
    public int getAverageBlockHeight() {
        return this.tag.getInteger("AverageBlockHeight");
    }

    @Override
    public boolean getIsTerrainPopulated() {
        return this.tag.getBoolean("TerrainPopulated");
    }

    @Override
    public double[] getTemperatureMap() {
        return this.tag.getDoubleArray("TemperatureMap");
    }

    @Override
    public double[] getHumidityMap() {
        return this.tag.getDoubleArray("HumidityMap");
    }

    @Override
    public byte[] getBiomeMap(int ySection, Map<Integer, String> biomeRegistry) {
        byte[] newBiomes = new byte[512];
        if (this.biome != null && ChunkReaderVersion1.makeBiomeIndex(15, ySection * 16 + 15, 15) < this.biome.length) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        byte newBiomeId;
                        int yOffset = ySection * 16;
                        byte oldBiomeId = this.biome[ChunkReaderVersion1.makeBiomeIndex(x, yOffset + y, z)];
                        newBiomes[ChunkSection.makeBiomeIndex((int)x, (int)y, (int)z)] = oldBiomeId < 0 ? oldBiomeId : (newBiomeId = (byte)Registries.BIOMES.getNumericIdOfItem(Registries.BIOMES.getItem(biomeRegistry.get(oldBiomeId))));
                    }
                }
            }
        }
        return newBiomes;
    }

    @Override
    public Map<Integer, String> getBiomeRegistry() {
        CompoundTag registriesTag = this.tag.getCompoundOrDefault("Registries", null);
        CompoundTag biomesTag = null;
        if (registriesTag != null) {
            biomesTag = registriesTag.getCompoundOrDefault("Biomes", null);
        }
        if (registriesTag == null || biomesTag == null) {
            return null;
        }
        return Registry.readIdMapFromTag(biomesTag);
    }
}

