/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.season;

import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonColorProperties;

public abstract class SeasonColorized
extends Season {
    SeasonColorProperties scp = null;

    public SeasonColorized(String id, boolean hasFallingLeaves, boolean hasDeeperSnow) {
        super(id, hasFallingLeaves, hasDeeperSnow);
    }

    @Override
    public int getPeakGrassColorizer(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.none) {
            return color;
        }
        if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.modify) {
            if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.flat) {
                r = (int)(this.scp.grassR * 255.0f);
            } else if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.mult) {
                r = (int)((float)r * this.scp.grassR);
            } else if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.add) {
                r = (int)((float)r + this.scp.grassR);
            }
            if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.flat) {
                g = (int)(this.scp.grassG * 255.0f);
            } else if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.mult) {
                g = (int)((float)g * this.scp.grassG);
            } else if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.add) {
                g = (int)((float)g + this.scp.grassG);
            }
            if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.flat) {
                b = (int)(this.scp.grassB * 255.0f);
            } else if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.mult) {
                b = (int)((float)b * this.scp.grassB);
            } else if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.add) {
                b = (int)((float)b + this.scp.grassB);
            }
        } else if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.desaturate) {
            int grey = (r + g + b) / 3;
            int dr = r - grey;
            int dg = g - grey;
            int db = b - grey;
            r = this.scp.grassRMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dr * this.scp.grassR) : grey;
            g = this.scp.grassGMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dg * this.scp.grassG) : grey;
            b = this.scp.grassBMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)db * this.scp.grassB) : grey;
        }
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return r << 16 | g << 8 | b << 0;
    }

    @Override
    public int getPeakFoliageColorizer(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.none) {
            return color;
        }
        if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.modify) {
            if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.flat) {
                r = (int)(this.scp.foliageR * 255.0f);
            } else if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.mult) {
                r = (int)((float)r * this.scp.foliageR);
            } else if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.add) {
                r = (int)((float)r + this.scp.foliageR);
            }
            if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.flat) {
                g = (int)(this.scp.foliageG * 255.0f);
            } else if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.mult) {
                g = (int)((float)g * this.scp.foliageG);
            } else if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.add) {
                g = (int)((float)g + this.scp.foliageG);
            }
            if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.flat) {
                b = (int)(this.scp.foliageB * 255.0f);
            } else if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.mult) {
                b = (int)((float)b * this.scp.foliageB);
            } else if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.add) {
                b = (int)((float)b + this.scp.foliageB);
            }
        } else if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.desaturate) {
            int grey = (r + g + b) / 3;
            int dr = r - grey;
            int dg = g - grey;
            int db = b - grey;
            r = this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dr * this.scp.foliageR) : grey;
            g = this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dg * this.scp.foliageG) : grey;
            b = this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)db * this.scp.foliageB) : grey;
        }
        return MathHelper.clamp(r, 0, 255) << 16 | MathHelper.clamp(g, 0, 255) << 8 | MathHelper.clamp(b, 0, 255) << 0;
    }
}

