/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import java.util.Arrays;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.debug.ChunkGeneratorDebug;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManagerGeneric;

public class WorldTypeDebug
extends WorldType {
    public WorldTypeDebug(String languageKey) {
        super(languageKey, Weather.overworldClear, new WindManagerGeneric(), false, WorldTypeDebug.createLightRamp(), SeasonConfig.builder().withSingleSeason(Seasons.NULL).build());
    }

    private static float[] createLightRamp() {
        float[] brightnessRamp = new float[32];
        Arrays.fill(brightnessRamp, 1.0f);
        return brightnessRamp;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public int getOceanY() {
        return 0;
    }

    @Override
    public int getOceanBlock() {
        return 0;
    }

    @Override
    public int getFillerBlock() {
        return 0;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_PLAINS, 1.0, 1.0, 1.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorDebug(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void getInitialSpawnLocation(World world) {
        world.getLevelData().setSpawn(0, 1, 0);
    }

    @Override
    public void getRespawnLocation(World world) {
    }

    @Override
    public int getDayNightCycleLengthTicks() {
        return 24000;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.0f;
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        return new float[4];
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        return 0;
    }

    @Override
    public Vec3d getFogColor(float timeOfDay, float partialTick) {
        return Vec3d.createVector(1.0, 1.0, 1.0);
    }

    @Override
    public boolean mayRespawn() {
        return true;
    }

    @Override
    public float getCloudHeight() {
        return 108.0f;
    }

    @Override
    public boolean hasGround() {
        return false;
    }
}

