/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypeOverworld;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManagerGeneric;

public class WorldTypeOverworldInland
extends WorldTypeOverworld {
    public WorldTypeOverworldInland(String languageKey) {
        super(languageKey, Weather.overworldClear, new WindManagerGeneric(), SeasonConfig.builder().withSeasonInCycle(Seasons.OVERWORLD_SPRING, 7).withSeasonInCycle(Seasons.OVERWORLD_SUMMER, 7).withSeasonInCycle(Seasons.OVERWORLD_FALL, 7).withSeasonInCycle(Seasons.OVERWORLD_WINTER, 7).build());
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderOverworld(world.getRandomSeed(), this).withTemperatureScales(0.00625, 0.00625, 0.25, 0.01).withHumidityScales(0.0125, 0.0125, 0.3, 0.01).withFuzzinessScales(8.0, 8.0, 0.025);
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 255;
    }

    @Override
    public int getOceanY() {
        return 0;
    }

    @Override
    public float getCloudHeight() {
        return 236.0f;
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return world.getBlockId(x, y, z) == Block.grass.id;
    }
}

