/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import java.io.IOException;
import java.net.Socket;
import java.security.Key;
import java.util.Random;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet136SendKey;
import net.minecraft.core.net.packet.Packet143PhotoMode;
import net.minecraft.core.net.packet.Packet1Login;
import net.minecraft.core.net.packet.Packet201Ids;
import net.minecraft.core.net.packet.Packet254PingHandshake;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.net.packet.Packet2Handshake;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.net.packet.Packet41EntityPlayerGamemode;
import net.minecraft.core.net.packet.Packet4UpdateTime;
import net.minecraft.core.net.packet.Packet6SpawnPosition;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.core.net.packet.Packet74GameRule;
import net.minecraft.core.net.packet.Packet75RecipeSync;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;
import net.minecraft.server.net.handler.NetServerHandler;
import net.minecraft.server.net.thread.ThreadLoginVerifier;
import net.minecraft.server.world.WorldServer;
import org.apache.log4j.Logger;

public class NetLoginHandler
extends NetHandler {
    public static String kickMessage = null;
    public static Logger logger = Logger.getLogger((String)"Minecraft");
    private static Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private Packet1Login packet1login = null;
    private String serverId = "";

    public NetLoginHandler(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this);
        this.netManager.packetSendDelay = 0;
    }

    public void tryLogin() {
        if (this.packet1login != null) {
            this.doLogin(this.packet1login);
            this.packet1login = null;
        }
        if (this.loginTimer++ == 600) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        this.kickUser(s, false);
    }

    public void kickUser(String s, boolean silent) {
        try {
            if (!silent) {
                logger.info((Object)("Disconnecting " + this.getUserAndIPString() + ": " + s));
            }
            this.netManager.addToSendQueue(new Packet255KickDisconnect(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2handshake) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new Packet2Handshake(this.serverId));
        } else {
            this.netManager.addToSendQueue(new Packet2Handshake("-"));
        }
    }

    @Override
    public void handleLogin(Packet1Login packet1login) {
        this.username = packet1login.username;
        if (packet1login.playerEntityIdAndProtocolVersion != 4919) {
            if (packet1login.playerEntityIdAndProtocolVersion > 4919) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(packet1login);
        } else {
            new ThreadLoginVerifier(this, packet1login).start();
        }
    }

    public void doLogin(Packet1Login packet1login) {
        EntityPlayerMP entityplayermp = this.mcServer.playerList.getPlayerForLogin(this, packet1login.username);
        if (entityplayermp != null) {
            this.mcServer.playerList.load(entityplayermp);
            entityplayermp.setWorld(this.mcServer.getDimensionWorld(entityplayermp.dimension));
            logger.info((Object)(this.getUserAndIPString() + " logged in with entity id " + entityplayermp.id + " at (" + entityplayermp.x + ", " + entityplayermp.y + ", " + entityplayermp.z + ")"));
            WorldServer worldserver = this.mcServer.getDimensionWorld(entityplayermp.dimension);
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            NetServerHandler netserverhandler = new NetServerHandler(this.mcServer, this.netManager, entityplayermp);
            try {
                netserverhandler.sendPacket(new Packet1Login("", entityplayermp.id, worldserver.getRandomSeed(), (byte)worldserver.dimension.id, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.dimensionData.getWorldType()), NetworkManager.PACKET_DELAY, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                Key aesKey = AES.generateKey();
                netserverhandler.sendPacket(new Packet136SendKey(RSA.encrypt(AES.getKey(aesKey), RSA.getPublicKey(packet1login.publicKey))));
                AES.keyChain.put(entityplayermp.username, aesKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            netserverhandler.sendPacket(new Packet6SpawnPosition(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z));
            this.mcServer.playerList.func_28170_a(entityplayermp, worldserver);
            this.mcServer.playerList.sendPacketToAllPlayers(new Packet3Chat(TextFormatting.YELLOW + entityplayermp.getDisplayName() + TextFormatting.YELLOW + " joined the game."));
            this.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(entityplayermp.username, entityplayermp.nickname, entityplayermp.score, entityplayermp.chatColor, true, entityplayermp.isOperator()));
            if (this.mcServer.joinMessage != null && this.mcServer.joinMessage.length() > 0) {
                entityplayermp.playerNetServerHandler.sendPacket(new Packet3Chat(this.mcServer.joinMessage));
            }
            this.mcServer.playerList.playerLoggedIn(entityplayermp);
            netserverhandler.teleportAndRotate(entityplayermp.x, entityplayermp.y, entityplayermp.z, entityplayermp.yRot, entityplayermp.xRot);
            this.mcServer.networkServer.addPlayer(netserverhandler);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet41EntityPlayerGamemode(entityplayermp.gamemode.getId()));
            netserverhandler.sendPacket(new Packet4UpdateTime(worldserver.getWorldTime()));
            entityplayermp.func_20057_k();
            if (MinecraftServer.statsStatus) {
                RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
            }
            entityplayermp.playerNetServerHandler.sendPacket(new Packet143PhotoMode(this.mcServer.disablePhotoMode));
            entityplayermp.playerNetServerHandler.sendPacket(new Packet74GameRule(this.mcServer.getDimensionWorld(0).getLevelData().getGameRules()));
            for (RecipeEntryBase<?, ?, ?> recipe : Registries.RECIPES.getAllSerializableRecipes()) {
                entityplayermp.playerNetServerHandler.sendPacket(new Packet75RecipeSync(recipe, Registries.RECIPES.getAllSerializableRecipes().size()));
            }
            entityplayermp.playerNetServerHandler.sendPacket(new Packet201Ids());
        }
        this.finishedProcessing = true;
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info((Object)(this.getUserAndIPString() + " lost connection"));
        this.finishedProcessing = true;
    }

    @Override
    public void handlePingHandshake(Packet254PingHandshake packet) {
        String msg = "";
        if (packet.pingHostString.equals("MC|PingHost")) {
            msg = "\u00a71\u00000\u0000BTA The Wombat Update\u0000" + this.mcServer.motd + '\u0000' + 0 + '\u0000' + 0;
        } else if (packet.pingHostString.equals("BTAPingHost")) {
            msg = "\u00a71\u00004919\u0000The Wombat Update\u0000" + this.mcServer.motd + '\u0000' + this.mcServer.playerList.playerEntities.size() + '\u0000' + this.mcServer.maxPlayers;
        }
        this.kickUser(msg, true);
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        if (kickMessage != null) {
            this.kickUser(kickMessage);
            kickMessage = null;
        } else {
            this.kickUser("Protocol error");
        }
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }

    public static String getServerId(NetLoginHandler netloginhandler) {
        return netloginhandler.serverId;
    }

    public static Packet1Login setLoginPacket(NetLoginHandler netloginhandler, Packet1Login packet1login) {
        netloginhandler.packet1login = packet1login;
        return netloginhandler.packet1login;
    }
}

